(module hash-set
    (make-hash-set
     hash-set?
     hash-set
     list->hash-set
     hash-set-copy
     hash-set->list
     hash-set-count
     hash-set-empty?
     hash-set-contains?
     hash-set-adjoin
     hash-set-adjoin!
     hash-set-remove!
     hash-set-map
     hash-set-for-each
     hash-set-fold
     hash-set-union
     hash-set-union!
     hash-set-difference)

  (import srfi-9)
  (import hashtable)

  (define-record-type hash-set-t
    (make-hash-set* predicate table)
    hash-set?
    (predicate hash-set-predicate)
    (table hash-set-table))

  (define (hash-set-adjoin! fs k)
    (hashtable/put! (hash-set-table fs) k #t)
    fs)

  (define (hash-set-union! fs1 fs2)
    (hashtable/for-each (lambda (k v) (hash-set-adjoin! fs1 k))
			(hash-set-table fs2))
    fs1)

  (define (hash-set-copy fs)
    (hash-set-union! (make-hash-set (hash-set-predicate fs)) fs))

  (define (make-hash-set . params)
    (let ((predicate (if (null? params) eq? (car params))))
      (make-hash-set* predicate (make-hashtable predicate))))

  (define (hash-set . l)
    (list->hash-set l))

  (define (list->hash-set l . params)
    (let ((fs (apply make-hash-set params)))
      (for-each (lambda (x) (hash-set-adjoin! fs x)) l)
      fs))

  (define (hash-set->list fs)
    (hashtable/map (lambda (k v) k)
		   (hash-set-table fs)))

  (define (hash-set-count fs)
    (hashtable/size (hash-set-table fs)))

  (define (hash-set-empty? fs)
    (zero? (hash-set-count fs)))

  (define hash-set-contains?
    (let ((marker "marker"))
      (lambda (fs k)
	(not (eq? marker (hashtable/get (hash-set-table fs) k marker))))))

  (define (hash-set-adjoin fs k)
    (hash-set-adjoin! (hash-set-copy fs) k))

  (define (hash-set-remove! fs k)
    (hashtable/remove! (hash-set-table fs) k)
    fs)

  (define (hash-set-map fs proc)
    (hashtable/map (lambda (k v) (proc k))
		   (hash-set-table fs)))

  (define (hash-set-for-each fs proc)
    (hashtable/for-each (lambda (k v) (proc k))
			(hash-set-table fs)))

  (define (hash-set-fold fs proc seed)
    (hashtable/for-each (lambda (k v)
			  (set! seed (proc k seed)))
			(hash-set-table fs))
    seed)

  (define (hash-set-union fs1 fs2)
    (hash-set-union! (hash-set-copy fs1) fs2))

  (define (hash-set-difference fs1 fs2)
    (let* ((x (hash-set-copy fs1))
	   (xt (hash-set-table x)))
      (hashtable/for-each (lambda (k v) (hashtable/remove! xt k))
			  (hash-set-table fs2))
      x)))
