(require-library 'utils/xxexpr)
(require-library 'ssax/ssax)
(require-library 'utils/socket)

(module xml-networking
    (send-xml-to-port)
  
  (import xxexpr)
  (import ssax)
  (import socket)

  (define socket-timeout 10000)

  ;; Return a procedure for serialising an SXML tree to an output port and
  ;; parsing SXML from the response
  (define (sxml-send-function sxml-tree)
    (lambda (in out)
      (parameterize ((xml-double-quotes-mode #t))
        (pretty-print-xxexpr (list sxml-tree) out))
      (SSAX:XML->SXML in '())))

  ;; Send XML to a specified host and port
  (define (send-xml-to-port sxml-tree host port)
    (call/plain-socket-ports host port #f (sxml-send-function sxml-tree)))
  )
