/*

Parameters to be filled in by Ant:
%db.name*
%db.owner*

TODO:
- make sure everything has a primary key defined
- likewise all foreign keys are declared
- put some sensible indexes on

*/

IF EXISTS (SELECT name FROM master.dbo.sysdatabases WHERE name = N'%db.name*')
	   RAISERROR('Database already exists... exiting', 16, 1)
	ELSE
  	 CREATE DATABASE %db.name*

GO

-- **************************************************

use %db.name*

CREATE TABLE [%db.name*].[%db.owner*].[users] (
  username nvarchar (50) PRIMARY KEY NOT NULL,
  password nvarchar (32) NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[roles] (
  username nvarchar (50) NOT NULL REFERENCES users (username),
  rolename nvarchar (50) NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[registration_rate_group] (
	position int PRIMARY KEY CLUSTERED NOT NULL,
	name nvarchar (100) NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[registration_rate] (
	guid uniqueidentifier PRIMARY KEY CLUSTERED DEFAULT (NEWID()) NOT NULL,
	name nvarchar (100) NOT NULL,
	price money NOT NULL,
	rate_group int NOT NULL,
	group_position int NOT NULL,
	published nvarchar (50) NOT NULL DEFAULT ('unpublished')
)

CREATE TABLE [%db.name*].[%db.owner*].[timeslot] (
	guid uniqueidentifier PRIMARY KEY CLUSTERED DEFAULT (NEWID()) NOT NULL,
	published nvarchar (50) NOT NULL DEFAULT ('unpublished'),
	starttime datetime NOT NULL,
	endtime datetime NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[session] (
	guid uniqueidentifier PRIMARY KEY CLUSTERED DEFAULT (NEWID()) NOT NULL,
	published nvarchar (50) NOT NULL DEFAULT ('unpublished'),
	title nvarchar(300) NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[session_timeslot] (
	session_guid uniqueidentifier NOT NULL REFERENCES session (guid),
	timeslot_guid uniqueidentifier NOT NULL REFERENCES timeslot (guid)
)

CREATE TABLE [%db.name*].[%db.owner*].[socialfunction] (
	guid uniqueidentifier PRIMARY KEY CLUSTERED DEFAULT (NEWID()) NOT NULL,
	published nvarchar (50) NOT NULL DEFAULT ('unpublished'),
	starttime datetime NOT NULL,
	title nvarchar(300) NOT NULL,
	price money NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[hotel] (
	guid uniqueidentifier PRIMARY KEY CLUSTERED DEFAULT (NEWID()) NOT NULL,
	published nvarchar (50) NOT NULL DEFAULT ('unpublished'),
	name nvarchar(100) NOT NULL,
	starcount int NOT NULL,
	walkingdistance nvarchar (100) NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[hotelroom] (
	guid uniqueidentifier PRIMARY KEY CLUSTERED DEFAULT (NEWID()) NOT NULL,
	published nvarchar (50) NOT NULL DEFAULT ('unpublished'),
	hotel_guid uniqueidentifier NOT NULL REFERENCES hotel (guid),
	roomtype nvarchar (50) NOT NULL,
	price money NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[dietaryrequirement] (
	guid uniqueidentifier PRIMARY KEY CLUSTERED DEFAULT (NEWID()) NOT NULL,
	published nvarchar (50) NOT NULL DEFAULT ('unpublished'),
	name nvarchar(100) NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[title] (
	published nvarchar (50) NOT NULL DEFAULT ('unpublished'),
	title nvarchar(50) PRIMARY KEY NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[registration] (
	guid uniqueidentifier PRIMARY KEY CLUSTERED DEFAULT (NEWID()) NOT NULL,
	title nvarchar(50) NOT NULL REFERENCES title (title),
	firstname nvarchar(255) NOT NULL,
	lastname nvarchar(255) NOT NULL,
	company nvarchar(255) NOT NULL,
	jobtitle nvarchar(255) NOT NULL,
	address_line_1 nvarchar(255) NOT NULL,
	address_line_2 nvarchar(255) NOT NULL,
	address_line_3 nvarchar(255) NOT NULL,
	town nvarchar(255) NOT NULL,
	county nvarchar(255) NOT NULL,
	postcode nvarchar(50) NOT NULL,
	country nvarchar(50) NOT NULL,
	telephone nvarchar(255) NOT NULL,
	fax nvarchar(255) NOT NULL,
	email nvarchar(255) NOT NULL,
	mobile nvarchar(255) NOT NULL,

	rate_selection uniqueidentifier NOT NULL REFERENCES registration_rate (guid),

	hotelroom_guid uniqueidentifier NULL REFERENCES hotelroom (guid),
	checkin datetime NULL,
	checkout datetime NULL,
	specialrequirements_hotel nvarchar(255) NOT NULL,
	companionname nvarchar(255) NOT NULL,

	specialrequirements_dietary nvarchar(255) NOT NULL
)
	
CREATE TABLE [%db.name*].[%db.owner*].[registration_session] (
	registration_guid uniqueidentifier NOT NULL REFERENCES registration (guid),
	session_guid uniqueidentifier NOT NULL REFERENCES session (guid)
)

CREATE TABLE [%db.name*].[%db.owner*].[registration_socialfunction] (
	registration_guid uniqueidentifier NOT NULL REFERENCES registration (guid),
	socialfunction_guid uniqueidentifier NOT NULL REFERENCES socialfunction (guid)
)

CREATE TABLE [%db.name*].[%db.owner*].[registration_dietaryrequirement] (
	registration_guid uniqueidentifier NOT NULL REFERENCES registration (guid),
	dietaryrequirement_guid uniqueidentifier NOT NULL REFERENCES dietaryrequirement (guid)
)

CREATE TABLE [%db.name*].[%db.owner*].[registration_payment] (
	guid uniqueidentifier PRIMARY KEY CLUSTERED DEFAULT (NEWID()) NOT NULL,
	registration_guid uniqueidentifier NOT NULL REFERENCES registration (guid),
	payment_type nvarchar(50) NOT NULL, /* "conference" or "hotel" */
	encrypteddetail image NOT NULL, /* PGP-encrypted XML data */
	processed bit NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[registration_payment_email] (
	registration_payment_guid uniqueidentifier NOT NULL REFERENCES registration_payment (guid),
	admin_email_address nvarchar(255) NOT NULL
)

CREATE TABLE [%db.name*].[%db.owner*].[application_data] (
	booking_deadline datetime NOT NULL,
	conference_starttime datetime NOT NULL,
	conference_endtime datetime NOT NULL,
	hotelbooking_starttime datetime NOT NULL,
	hotelbooking_endtime datetime NOT NULL,
	conference_office_phone nvarchar(255) NOT NULL
)

GO
