<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:lshift="http://www.lshift.net/schema/scheme-xslt-ui#">
  <xsl:preserve-space elements="*"/>

  <!-- operates on the output of template compiler to produce examples of what the templates produce -->

  <xsl:template match="/xsl:stylesheet">
    <xsl:apply-templates select="xsl:template[@match='/*']/*"/>
  </xsl:template>

  <!-- hijack the base element so stylesheets etc. work -->
  <xsl:template match="base">
    <base href="."/>
  </xsl:template>

  <!-- likewise, with the head element, put our own stylesheet in there -->
  <xsl:template match="head">
    <xsl:apply-templates/>
    <link rel="stylesheet" href="static/styles/template-example.css" type="text/css"/>
  </xsl:template>

  <xsl:template match="xsl:attribute">
    <xsl:attribute name="{@name}"><xsl:value-of select="."/></xsl:attribute>
  </xsl:template>

  <xsl:template match="xsl:for-each">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="xsl:for-each/*">
    <xsl:copy>
      <xsl:attribute name="class">
	template-for-each
	<xsl:value-of select="@class"/>
      </xsl:attribute>
      <!-- problematic for things like table rows
	   <span class="template-path"><xsl:value-of select="@select"/></span>
      -->
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="xsl:if">
    <div class="template-if">
      <span class="template-test"><xsl:value-of select="@test"/></span>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="xsl:if[xsl:attribute]">
    <xsl:apply-templates select="*"/>
  </xsl:template>

  <xsl:template match="xsl:choose">
    <div class="template-choose">
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="xsl:when">
    <div class="template-when">
      <span class="template-test"><xsl:value-of select="@test"/></span>
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="xsl:otherwise">
    <div class="template-otherwise">
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="xsl:value-of">
    <span class="template-value-of"><xsl:value-of select="@select"/></span>
  </xsl:template>

  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

</xsl:stylesheet>
