<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:outxsl="http://www.lshift.net/output-xsl-namespace-alias#"
		xmlns:lshift="http://www.lshift.net/schema/scheme-xslt-ui#">
  <xsl:preserve-space elements="*"/>

  <xsl:namespace-alias stylesheet-prefix="outxsl"
		       result-prefix="xsl"/>

  <xsl:template match="lshift:param"/>

  <xsl:template match="form[@lshift:action]">
    <xsl:copy>
      <xsl:attribute name="action">{$k-url}</xsl:attribute>
      <xsl:if test="not(./@method)">
	<xsl:attribute name="method">POST</xsl:attribute>
      </xsl:if>
      <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="span[@lshift:errormessage]">
    <xsl:copy>
      <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
      <xsl:if test="not(./@class)">
	<xsl:attribute name="class">forms-ui-errormessage</xsl:attribute>
      </xsl:if>
      <outxsl:value-of select="./{./@lshift:errormessage}/field/errormessage"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="span[@lshift:controlgroupanchor]">
    <xsl:copy>
      <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
      <input type="hidden" value="1" name="_{{./{./@lshift:controlgroupanchor}/field/name}}"/>
      <xsl:apply-templates/>
      <xsl:call-template name="maybe-error-message">
	<xsl:with-param name="node" select="."/>
	<xsl:with-param name="field" select="./@lshift:controlgroupanchor"/>
      </xsl:call-template>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="maybe-error-message">
    <xsl:param name="node"/>
    <xsl:param name="field"/>
    <xsl:if test="not($node/@lshift:noerrormessage)">
      <span class="forms-ui-errormessage">
	<outxsl:value-of select="./{$field}/field/errormessage"/>
      </span>
    </xsl:if>
  </xsl:template>

  <xsl:template name="output-value-lookup-code">
    <xsl:param name="fieldpath"/>
    <outxsl:variable name="fieldroot" select="./{$fieldpath}/field"/>
    <outxsl:for-each select="$fieldroot/options/option">
      <outxsl:if test="./value = $fieldroot/value[1]">
	<outxsl:value-of select="./label"/>
      </outxsl:if>
    </outxsl:for-each>
  </xsl:template>

  <xsl:template match="span[@lshift:field]">
    <xsl:copy>
      <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
      <xsl:choose>
	<xsl:when test="@lshift:lookup">
	  <xsl:call-template name="output-value-lookup-code">
	    <xsl:with-param name="fieldpath" select="./@lshift:field"/>
	  </xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
	  <outxsl:value-of select="./{./@lshift:field}/field/value[1]"/>
	</xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template name="maybe-readonly">
    <xsl:param name="control-source"/>
    <xsl:param name="readonly-condition"/>
    <xsl:param name="control-result"/>
    <xsl:choose>
      <xsl:when test="normalize-space($readonly-condition) = ''">
	<xsl:copy-of select="$control-result"/>
      </xsl:when>
      <xsl:otherwise>
	<outxsl:choose>
	  <outxsl:when test="{$readonly-condition}">
	    <xsl:apply-templates select="$control-source" mode="readonly-control"/>
	  </outxsl:when>
	  <outxsl:otherwise>
	    <xsl:copy-of select="$control-result"/>
	  </outxsl:otherwise>
	</outxsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template mode="readonly-control"
		match="input[(@type='text' or @type='password')]">
    <span class="forms-ui-readonly-control forms-ui-readonly-control-{@type}">
      <outxsl:value-of select="./{./@lshift:field}/field/value[1]"/>
    </span>
  </xsl:template>

  <xsl:template match="input[(@type='text' or @type='password') and @lshift:field]">
    <xsl:call-template name="maybe-readonly">
      <xsl:with-param name="control-source" select="."/>
      <xsl:with-param name="readonly-condition" select="./@lshift:readonly-if"/>
      <xsl:with-param name="control-result">
	<input type="hidden" value="1" name="_{{./{./@lshift:field}/field/name}}"/>
	<xsl:copy>
	  <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
	  <xsl:attribute name="name">{./<xsl:value-of select="./@lshift:field"/>/field/name}</xsl:attribute>
	  <xsl:attribute name="id">{./<xsl:value-of select="./@lshift:field"/>/field/name}</xsl:attribute>
	  <xsl:attribute name="value">{./<xsl:value-of select="./@lshift:field"/>/field/value[1]}</xsl:attribute>
	  <xsl:if test="not(./@size)">
	    <outxsl:if test="./{./@lshift:field}/field/size != ''">
	      <outxsl:attribute name="size"><outxsl:value-of select="./{./@lshift:field}/field/size"/></outxsl:attribute>
	    </outxsl:if>
	  </xsl:if>
	  <xsl:if test="not(./@maxlength)">
	    <outxsl:if test="./{./@lshift:field}/field/maxlength != ''">
	      <outxsl:attribute name="maxlength"><outxsl:value-of select="./{./@lshift:field}/field/maxlength"/></outxsl:attribute>
	    </outxsl:if>
	  </xsl:if>
	  <xsl:apply-templates/>
	  <xsl:if test="@lshift:calendar">
	    <script type="text/javascript">
	      Calendar.setup({
	        inputField     :    '<outxsl:value-of select="./{./@lshift:field}/field/name"/>',
		ifFormat       :    '%Y-%m-%d',
		showsTime      :    false,
		timeFormat     :    "24",
		weekNumbers    :    false
	      });
	    </script>
	  </xsl:if>
	</xsl:copy>
	<xsl:call-template name="maybe-error-message">
	  <xsl:with-param name="node" select="."/>
	  <xsl:with-param name="field" select="./@lshift:field"/>
	</xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template mode="readonly-control"
		match="textarea">
    <div class="forms-ui-readonly-control forms-ui-readonly-control-textarea"><outxsl:value-of select="./{./@lshift:field}/field/value[1]"/></div>
  </xsl:template>

  <xsl:template match="textarea[@lshift:field]">
    <xsl:call-template name="maybe-readonly">
      <xsl:with-param name="control-source" select="."/>
      <xsl:with-param name="readonly-condition" select="./@lshift:readonly-if"/>
      <xsl:with-param name="control-result">
	<input type="hidden" value="1" name="_{{./{./@lshift:field}/field/name}}"/>
	<xsl:copy>
	  <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
	  <xsl:attribute name="xml:space">preserve</xsl:attribute>
	  <xsl:attribute name="name">{./<xsl:value-of select="./@lshift:field"/>/field/name}</xsl:attribute>
	  <xsl:if test="not(./@rows)">
	    <outxsl:if test="./{./@lshift:field}/field/rows != ''">
	      <outxsl:attribute name="rows"><outxsl:value-of select="./{./@lshift:field}/field/rows"/></outxsl:attribute>
	    </outxsl:if>
	  </xsl:if>
	  <xsl:if test="not(./@cols)">
	    <outxsl:if test="./{./@lshift:field}/field/cols != ''">
	      <outxsl:attribute name="cols"><outxsl:value-of select="./{./@lshift:field}/field/cols"/></outxsl:attribute>
	    </outxsl:if>
	  </xsl:if>
	  <outxsl:value-of select="./{@lshift:field}/field/value[1]"/>
	  <xsl:apply-templates/>
	</xsl:copy>
	<xsl:call-template name="maybe-error-message">
	  <xsl:with-param name="node" select="."/>
	  <xsl:with-param name="field" select="./@lshift:field"/>
	</xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template mode="readonly-control"
		match="input[@type='checkbox' or @type='radio']">
    <span class="forms-ui-readonly-control forms-ui-readonly-control-selector">
      <outxsl:choose>
	<outxsl:when test="./{./@lshift:itemfield}/field/value = ./{./@lshift:field}/field/value">
	  <span class="forms-ui-readonly-control-selector-checked">[yes]</span>
	</outxsl:when>
	<outxsl:otherwise>
	  <span class="forms-ui-readonly-control-selector-unchecked">[no]</span>
	</outxsl:otherwise>
      </outxsl:choose>
    </span>
  </xsl:template>

  <xsl:template match="input[(@type='checkbox' or @type='radio') and @lshift:field and @lshift:itemfield]">
    <xsl:call-template name="maybe-readonly">
      <xsl:with-param name="control-source" select="."/>
      <xsl:with-param name="readonly-condition" select="./@lshift:readonly-if"/>
      <xsl:with-param name="control-result">
	<xsl:copy>
	  <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
	  <xsl:attribute name="name">{./<xsl:value-of select="./@lshift:field"/>/field/name}</xsl:attribute>
	  <xsl:attribute name="id">{./<xsl:value-of select="./@lshift:itemfield"/>/field/name}</xsl:attribute>
	  <xsl:attribute name="value">{./<xsl:value-of select="./@lshift:itemfield"/>/field/value}</xsl:attribute>
	  <outxsl:if test="./{./@lshift:itemfield}/field/value = ./{./@lshift:field}/field/value">
	    <outxsl:attribute name="checked">checked</outxsl:attribute>
	  </outxsl:if>
	  <xsl:apply-templates/>
	</xsl:copy>
	<xsl:call-template name="maybe-error-message">
	  <xsl:with-param name="node" select="."/>
	  <xsl:with-param name="field" select="./@lshift:itemfield"/>
	</xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template mode="readonly-control"
		match="select">
    <span class="forms-ui-readonly-control forms-ui-readonly-control-select">
      <xsl:call-template name="output-value-lookup-code">
	<xsl:with-param name="fieldpath" select="./@lshift:field"/>
      </xsl:call-template>
    </span>
  </xsl:template>

  <xsl:template match="select[@lshift:field]">
    <xsl:call-template name="maybe-readonly">
      <xsl:with-param name="control-source" select="."/>
      <xsl:with-param name="readonly-condition" select="./@lshift:readonly-if"/>
      <xsl:with-param name="control-result">
	<input type="hidden" value="1" name="_{{./{./@lshift:field}/field/name}}"/>
	<xsl:copy>
	  <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
	  <xsl:attribute name="name">{./<xsl:value-of select="./@lshift:field"/>/field/name}</xsl:attribute>
	  <outxsl:variable name="fieldroot" select="./{./@lshift:field}/field"/>
	  <outxsl:for-each select="$fieldroot/options/option">
	    <option value="{{./value}}">
	      <outxsl:if test="./value = $fieldroot/value[1]">
		<outxsl:attribute name="selected">selected</outxsl:attribute>
	      </outxsl:if>
	      <outxsl:value-of select="./label"/>
	    </option>
	  </outxsl:for-each>
	</xsl:copy>
	<xsl:call-template name="maybe-error-message">
	  <xsl:with-param name="node" select="."/>
	  <xsl:with-param name="field" select="./@lshift:field"/>
	</xsl:call-template>
      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>

  <xsl:template match="input[@type='submit' and @lshift:action]">
    <xsl:copy>
      <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
      <xsl:attribute name="name">X_action</xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="./@lshift:action"/></xsl:attribute>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="label[@lshift:field]">
    <xsl:copy>
      <xsl:attribute name="for">{./<xsl:value-of select="./@lshift:field"/>/field/name}</xsl:attribute>
      <xsl:choose>
	<xsl:when test="@class">
	  <outxsl:attribute name="class">
	    <xsl:value-of select="@class"/>
	    <outxsl:if test="./{./@lshift:field}/field/required"> forms-ui-required-control-label</outxsl:if>
	  </outxsl:attribute>
	</xsl:when>
	<xsl:otherwise>
	  <outxsl:if test="./{./@lshift:field}/field/required">
	    <outxsl:attribute name="class">forms-ui-required-control-label</outxsl:attribute>
	  </outxsl:if>
	</xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="a[@lshift:splice-field]">
    <xsl:variable name="varname" select="substring-before(@lshift:splice-field,'=')"/>
    <xsl:variable name="varfield" select="substring-after(@lshift:splice-field,'=')"/>
    <xsl:copy>
      <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#' and local-name() != 'href']"/>
      <xsl:attribute name="href">{concat('<xsl:value-of select="substring-before(@href,$varname)"/>', ./<xsl:value-of select="$varfield"/>/field/value[1], '<xsl:value-of select="substring-after(@href,$varname)"/>')}</xsl:attribute>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="*[@lshift:for-each]">
    <xsl:copy>
      <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
      <outxsl:for-each select="./{./@lshift:for-each}">
	<xsl:apply-templates/>
      </outxsl:for-each>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="*[@lshift:repeat]">
      <outxsl:for-each select="./{./@lshift:repeat}">
	<xsl:copy>
	  <xsl:copy-of select="@*[namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
	  <xsl:apply-templates/>
	</xsl:copy>
      </outxsl:for-each>
  </xsl:template>

  <xsl:template match="/html/head">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <base href="{{$base-uri}}"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="/*">
    <outxsl:stylesheet version="1.0">
      <xsl:text>
</xsl:text>
      <xsl:comment> **** WARNING: This file was autogenerated from an (X)HTML template **** </xsl:comment><xsl:text>
</xsl:text>
      <outxsl:preserve-space elements="*"/><xsl:text>
</xsl:text>
      <outxsl:output method="html"
		     omit-xml-declaration="yes"
		     encoding="UTF-8"
		     indent="yes"
		     doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
		     /><xsl:text>
</xsl:text>
      <outxsl:param name="base-uri"/><xsl:text>
</xsl:text>
      <outxsl:param name="k-url"/><xsl:text>
</xsl:text>
      <xsl:for-each select="//lshift:param">
	<outxsl:param name="{.}"/><xsl:text>
</xsl:text>
      </xsl:for-each>
      <outxsl:template match="/*">
	<xsl:copy>
	  <xsl:copy-of select="@*[local-name() != 'param' or namespace-uri() != 'http://www.lshift.net/schema/scheme-xslt-ui#']"/>
	  <xsl:apply-templates/>
	</xsl:copy>
      </outxsl:template><xsl:text>
</xsl:text>
    </outxsl:stylesheet>
  </xsl:template>

  <xsl:template match="*">
    <xsl:copy>
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
</xsl:stylesheet>
