; Binary vector class

(define-class <binary-vector> <object> ())

(define-method initialize <binary-vector>
  (lambda (self . vals)
    (let* ((length (list-length vals))
	   (self (simple-make <binary-vector> 0 length)))
      (let loop ((vals vals) (num 0))
	(cond
	 ((null? vals))
	 (else
	  (binary-set! self num (car vals))
	  (loop (cdr vals) (+ num 1)))))
      self)))

(define-method print-string <binary-vector>
  (lambda (self w)
    (let ((length (binary-length self)))
      (+ "#["
	 (let loop ((idx 0))
	   (if (= idx length)
	       "]"
	       (+ (print-string (binary-ref self idx) #f)
		  (+ (if (< idx (- length 1))
			 " "
			 "")
		     (loop (+ idx 1))))))))))

(define (binary-vector . args)
  (apply make <binary-vector> args))
