; <dictionary>

(require 'avl-tree)

(define-class <dictionary> <avl-tree> ())

(define-class <eq-dictionary> <dictionary> ())
(define-class <equal-dictionary> <dictionary> ())

(define-class <association> <object> (assoc-key assoc-value))

(define-method initialize <eq-dictionary>
  (lambda (self)
    (next-method self
		 (lambda (lhs rhs)
		   (< (hash-for-eq (assoc-key lhs))
		      (hash-for-eq (assoc-key rhs))))
		 (lambda (lhs rhs)
		   (eq? (assoc-key lhs)
			(assoc-key rhs))))))

(define-method initialize <equal-dictionary>
  (lambda (self)
    (next-method self
		 (lambda (lhs rhs)
		   (< (hash-for-equal (assoc-key lhs))
		      (hash-for-equal (assoc-key rhs))))
		 (lambda (lhs rhs)
		   (equal? (assoc-key lhs)
			   (assoc-key rhs))))))

(define-method insert <dictionary>
  (lambda (self key value)
    (next-method self (make <association> key value))))

(define-method lookup <dictionary>
  (lambda (self key)
    (next-method self (make <association> key 'no-significant-value))))

(define-method initialize <association>
  (lambda (self key value)
    (set-assoc-key! self key)
    (set-assoc-value! self value)
    self))

(define-method print-string <association>
  (lambda (self w)
    (+ "["
       (+ (print-string (assoc-key self) #t)
	  (+ ": "
	     (+ (print-string (assoc-value self) #t) "]"))))))
