; <queue>

(define-class <queue> <object> (queue-head queue-tail))

(define-class <queue-node> <object> (queue-node-value queue-node-prev queue-node-next))

(define-method initialize <queue>
  (lambda (self)
    (set-queue-head! self #f)
    (set-queue-tail! self #f)
    self))

(define-method insert <queue>
  (lambda (self value)
    (let ((node (make <queue-node> value (queue-tail self) #f)))
      (if (queue-tail self)
	  (set-queue-node-next! (queue-tail self) node))
      (if (not (queue-head self))
	  (set-queue-head! self node))
      (set-queue-tail! self node))))

(define-method remove <queue>
  (lambda (self value)
    (let walk ((node (queue-head self)))
      (cond
       ((not node)
	#f)
       ((eq? (queue-node-value node) value)
	(if (queue-node-prev node)
	    (set-queue-node-next! (queue-node-prev node)
				  (queue-node-next node))
	    (set-queue-head! self (queue-node-next node)))
	(if (queue-node-next node)
	    (set-queue-node-prev! (queue-node-next node)
				  (queue-node-prev node))
	    (set-queue-tail! self (queue-node-prev node))))
       (else
	(walk (queue-node-next node)))))))

(define-method empty? <queue>
  (lambda (self)
    (not (queue-head self))))

(define-method contains? <queue>
  (lambda (self what)
    (let walk ((node (queue-head self)))
      (cond
       ((not node) #f)
       ((eq? (queue-node-value node) what) #t)
       (else (walk (queue-node-next node)))))))

(define-method dequeue <queue>
  (lambda (self)
    (let ((node (queue-head self)))
      (if node
	  (begin
	    (set-queue-head! self (queue-node-next node))
	    (if (eq? (queue-tail self) node)
		(set-queue-tail! self #f))	; Guaranteed to be #f, because it's the tail.
	    (set-queue-node-next! node #f)
	    (set-queue-node-prev! node #f)
	    node)
	  #f))))

(define-method iterate-over <queue>
  (lambda (self func)
    (let walk ((node (queue-head self)))
      (if node
	  (begin
	    (func (queue-node-value node))
	    (walk (queue-node-next node)))))))

(define-method iterate-over-backwards <queue>
  (lambda (self func)
    (let walk ((node (queue-tail self)))
      (if node
	  (begin
	    (func (queue-node-value node))
	    (walk (queue-node-prev node)))))))

(define-method print-string <queue>
  (lambda (self w)
    (+ "#<queue "
       (let walk ((node (queue-head self)))
	 (if node
	     (+ (print-string (queue-node-value node) w)
		(+ (if (queue-node-next node)
		       ", "
		       "")
		   (walk (queue-node-next node))))
	     ">")))))

(define-method initialize <queue-node>
  (lambda (self value p n)
    (set-queue-node-value! self value)
    (set-queue-node-prev! self p)
    (set-queue-node-next! self n)
    self))

(define-method print-string <queue-node>
  (lambda (self w)
    (+ "#<queue-node "
       (+ (print-string (queue-node-value self) w) ">"))))
