; R4RS.M
; Partial Scheme R4RS compatibility for Moof.
;
; Tony Garnock-Jones, 1 Oct 1997.
; tonyg@kcbbs.gen.nz

; NOT SUPPORTED:
;	* floats or inexact/exactness
;	* characters: both literal constants and character procedures
;	* '=>' in cond
;	* promises
;	* eqv? (not supported properly)
;	* internal (define) not supported properly (cf (begin) bug below)
;	* gcd and lcm
;	* make-string and most other string procedures
;	* multi-arg map
;	* ports
; BUGS:
;	* (begin <definition1> ...) doesn't work as in R4RS
;	* (cond (#t) (else 'x)) returns unspecified!
;	* modulo and remainder do the same thing

(define (boolean? x) (or (eq? x #f)
			 (eq? x #t)))

(define (pair? x) (instance? x <pair>))

(define (list? x)
  (or (null? x)
      (and (pair? x)
	   (list? (cdr x)))))

(define (symbol? x) (instance? x <symbol>))

(define (integer? x) (instance? x <integer>))
(define number? integer?)
(define complex? integer?)
(define real? integer?)
(define rational? integer?)
(define exact? integer?)
(define (inexact? x) #f)

(define (string? x) (instance? x <string>))

(define (vector? x) (instance? x <vector>))

(define (zero? x) (eq? x 0))
(define (positive? x) (> x 0))
(define (negative? x) (< x 0))

(define (even? x) (zero? (modulo x 2)))
(define (odd? x) (not (even? x)))

(define eqv? eq?)
(define memv memq)
(define assv assq)

(define length list-length)

(define (append . lists)
  (let i-append ((lists lists))
    (cond
     ((null? lists) '())
     ((null? (cdr lists)) (car lists))
     (else
      (let loop ((hd (car lists)))
	(if (null? hd)
	    (i-append (cdr lists))
	    (cons (car hd) (loop (cdr hd)))))))))

(define (reverse l)
  (let loop ((acc '()) (l l))
    (if (null? l)
	acc
	(loop (cons (car l) acc) (cdr l)))))

(define (list-tail l n)
  (if (zero? n)
      l
      (list-tail (cdr l) (- n 1))))

(define (list-ref l n)
  (car (list-tail l n)))

(define symbol->string as-string)
(define string->symbol as-symbol)

(define (r4rs:extend-binary-predicate PROC)
  (lambda args
    (let i-PROC ((args args))
      (cond
       ((null? args) #t)
       ((null? (cdr args)) #t)
       ((not (PROC (car args) (cadr args))) #f)
       (else (i-PROC (cdr args)))))))

(define = (r4rs:extend-binary-predicate =))
(define < (r4rs:extend-binary-predicate <))
(define > (r4rs:extend-binary-predicate >))
(define <= (r4rs:extend-binary-predicate <=))
(define >= (r4rs:extend-binary-predicate >=))

(define (r4rs:extend-binary-operator seed proc)
  (lambda args
    (if (null? args)
	seed
	(reduce proc (car args) (cdr args)))))

(define max
  (let ((old-max max))
    (lambda (f . args)
      (reduce old-max f args))))

(define min
  (let ((old-min min))
    (lambda (f . args)
      (reduce old-min f args))))

(define + (r4rs:extend-binary-operator 0 +))
(define * (r4rs:extend-binary-operator 1 *))

(define -
  (let ((old-- -))
    (lambda (f . args)
      (if (null? args)
	  (old-- 0 f)
	  (reduce old-- f args)))))

(define /
  (let ((old-/ /))
    (lambda (f . args)
      (if (null? args)
	  (old-/ 1 f)
	  (reduce old-/ f args)))))

(define (abs x)
  (if (negative? x)
      (- x)
      x))

(define quotient /)
(define remainder modulo)

(define number->string as-string)
(define (string->number x) (read-from (make <string-stream> x)))

(define string=? equal?)

(define (substring str a b)
  (cut-subseq str a (- b a)))

(define string-append +)

(define (make-vector . args) (apply make <vector> args))

(define vector-length indexed-length)
(define vector-ref indexed-ref)
(define vector-set! indexed-set!)

(define (vector-fill! vec f)
  (let ((len (vector-length vec)))
    (do ((i 0 (+ i 1)))
	((= i len) vec)
      (vector-set! vec i f))))

(define (procedure? x)
  (or (instance? x <function>)
      (instance? x <generic-function>)
      (instance? x <primitive-function>)
      (instance? x <continuation>)))

(define call-with-current-continuation call/cc)

(define display print)
