(define (repl-eval expr)
  (let* ((compiled-thunk (compile expr))
	 (result (begin
;		   (debug-level 2)
		   (let ((r (compiled-thunk)))
;		     (debug-level 0)
		     r))))
    (print "; Returned:")
    (newline)
    (write result)
    (newline)))

(require 'debug)

;(define repl-exception-handler
;    (lambda (exception args cont)
;        (print "\nException raised:\t\t")
;        (print exception)
;        (print
;"\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n")
;        (print "Arguments:\t\t\t")
;        (print args)
;        (print "\n\nDump continuation? ")
;        (stream-flush standard-input)
;        (let ((res (read)))
;            (if (and (instance? res <symbol>)
;                     (memq (binary-ref (symbol->string res) 0)
;                        '(#x59 #x79)))      ; that is, Y and y
;                (begin
;                    (print "\nContinuation dump:\n\n")
;                    (debug-dump cont))))
;        (newline)
;        (abort)))

(letrec ((repl-quit (lambda ()
		      (print "\n; Goodbye.\n")
		      (quit)))
	 (do-repl-defs (lambda (cc)
			 (set! abort
			       (lambda ()
				 (cc 'abort)))
			 'returning-from-do-repl-defs))
         (repl (lambda ()
		 (if (stream-at-eof? standard-input)
		     (repl-quit)
		     (begin
		       (print "> ")
		       (let ((expr (macro-expanding-read-from standard-input)))
			 (if (eof-object? expr)
			     (repl-quit)
			     (begin
			       (repl-eval expr)
			       (repl)))))))))
;  (install-handler repl-exception-handler)
  (fork
   (lambda ()
     (let ((result (call/cc do-repl-defs)))
       (repl)))))
