(define *library-database*
  '((require "require.m")
    (r4rs "r4rs.m")
    (scheme "r4rs.m")
    (disassemble "asm.m")
    (asm "asm.m")
    (avl-tree "avltree.m")
    (binary-vector "bvector.m")
    (debug "debug.m")
    (graphics "graphics.m")
    (hash-tree "hashtree.m")
    (hash-table "hashtable.m")
    (repl "repl.m")
    (dictionary "dict.m")
    (queue "queue.m")
    (set "set.m")
    (windowing-toolkit "wt.m")
    (widgets "wt-widgets.m")
    (stream "stream.m")))

(define verbose
  (let ((v #t))
    (lambda x
      (if (null? x)
	  v
	  (let ((old-v v))
	    (set! v (car x))
	    old-v)))))

(define (%%library-lookup name)
  (let ((cell (assq name *library-database*)))
    (if cell
	(car (cdr cell))
	(as-string name))))

(define (require name)
  (let ((sym (as-symbol name))
	(file (if (instance? name <symbol>)
		  (%%library-lookup name)
		  name)))
    (if (or (provided? sym)
	    (provided? (as-symbol file)))
	#t
	(begin
	  (if (verbose)
	      (begin
		(print ";loading ")
		(print file)
		(print " (required: ")
		(print name)
		(print ") ...\n")))
	  (let ((result (load file)))
	    (if result
		(begin
		  (if (not (provided? sym))
		      (set! *features* (cons sym *features*)))
		  (if (not (or (eq? name file)
			       (provided? (as-symbol file))))
		      (set! *features* (cons (as-symbol file) *features*)))))
	    (if (verbose)
		(begin
		  (print ";done loading ")
		  (print file)
		  (print ".\n")))
	    result)))))

(define (provide name)
  (if (instance? name <symbol>)
      (let ((file (%%library-lookup name)))
	(if (not (provided? name))
	    (set! *features* (cons name *features*)))
	(if (not (provided? file))
	    (set! *features* (cons (as-symbol file) *features*))))
      (if (not (provided? (as-symbol name)))
	  (set! *features* (cons (as-symbol name) *features*))))
  *features*)

(provide 'require)
