(define-method stream-size <stream>
    (lambda (self)
        (let ((pos (stream-tell self)))
            (stream-seek self 0 'end)
            (let ((end (stream-tell self)))
                (stream-seek self pos 'set)
                end))))

(define-method read-line-from <stream>
  (lambda (self)
    (let loop ((str "") (ch (read-chars-from self 1)))
      (cond
       ((null? ch)
	(if (equal? str "")
	    (*eof-object*)
	    str))
       ((member ch '("\n" "\r"))
	str)
       (else
	(loop (+ str ch) (read-chars-from self 1)))))))

(define-method stream-flush <stream>
  (lambda (self)
    (*undefined*)))

(define-method stream-at-eof? <stream>
  (lambda (self)
    #t))

(define-method stream-at-eof? <socket>
  (lambda (self)
    #f))
