/* $Id: buffer.c,v 1.2 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "buffer.h"

BUFFER newbuf(int initial_length) {
    BUFFER buf = getmem(sizeof(Buffer));

    buf->buflength = initial_length;
    buf->pos = 0;
    buf->buf = getmem(initial_length);

    return buf;
}

void killbuf(BUFFER buf) {
    freemem(buf->buf);
    freemem(buf);
}

void buf_append(BUFFER buf, char ch) {
    if (buf->pos >= buf->buflength) {
        buf->buf = growmem(buf->buf, buf->buflength, 128);
        buf->buflength += 128;
    }
    buf->buf[buf->pos++] = ch;
}

