/* $Id: bytecode.h,v 1.2 1998/04/05 10:33:48 tonyg Exp $ */

#ifndef Bytecode_H
#define Bytecode_H

#define OP_LITREF           0x00    /* OP litnum */
#define OP_LOCALREF         0x01    /* OP scopenum offset */
#define OP_SLOTREF          0x02    /* OP offset */
#define OP_GLOBALREF        0x03    /* OP litsymnum */

#define OP_LOCALSET         0x10    /* OP scopenum offset */
#define OP_SLOTSET          0x11    /* OP offset */
#define OP_GLOBALSET        0x12    /* OP litsymnum */
#define OP_LOCALSET_NAMED   0x13    /* OP scopenum offset litsymnum */

#define OP_PUSH             0x20    /* OP -- pushes accumulator */
#define OP_POP              0x21    /* OP -- pops into accumulator */

#define OP_ENTERSCOPE       0x30    /* OP scopesize */
#define OP_EXITSCOPE        0x31    /* OP */

#define OP_JUMP             0x40    /* OP lorelofs hirelofs */
#define OP_JUMP_FALSE       0x41    /* OP lorelofs hirelofs */
#define OP_JUMP_TRUE        0x42    /* OP lorelofs hirelofs */
#define OP_JUMP_EQ          0x43    /* OP lorelofs hirelofs */

#define OP_CALL             0x50    /* OP numargs */
#define OP_TAIL_CALL        0x51    /* OP numargs */
#define OP_CALL_NEXTMETHOD  0x52    /* OP numargs */
#define OP_TAIL_CALL_NEXT   0x53    /* OP numargs */
#define OP_RETURN           0x54    /* OP */

#define OP_MAKE_LAMBDA      0x60    /* OP litnum */

#endif
