/* $Id: config.h,v 1.8 1998/08/15 13:02:38 tonyg Exp $ */

#ifndef Config_H
#define Config_H

#include "patchlvl.h"

#ifndef MOOF_LIBDIR
#define MOOF_LIBDIR		"/usr/local/lib/moof"
#endif
#define MOOF_BOOTFILE		MOOF_LIBDIR "/startup.m"

#define MAX_AVAIL_HEAP		((long) 2048 * (long) 1024)	/* 2 megabytes (!) */
					/* Make sure (under MacOS) that the program has
					   at least _twice_ MAX_AVAIL_HEAP available to it
					   as heap space. */

#define WANT_SOCKETS		1	/* Set to nonzero if you want sockets. */
#define WANT_XWINDOWS		1	/* Set to nonzero if you want X11R6 support. */
#define WANT_FIXED_HEAP		0	/* Set to nonzero to make MOOF check if it has enough
					   memory, for itself, instead of relying on the OS
					   returning a NULL pointer when it has run out. */
#define WANT_DLL_SUPPORT	1	/* Set to nonzero to enable dynamic linking prims */
#define WANT_OSS_SOUND_SUPPORT	0	/* Set to nonzero to enable OSS (Linux) sound */

/* You shouldn't need to change below this line. */

/* Unless, that is, the system is guessing _wrong_ for your system. */
/* These next few lines guess the values for certain #defines. */

#ifdef __MWERKS__
# if WANT_SOCKETS
#  undef WANT_SOCKETS
#  define WANT_SOCKETS 0	/* Sockets aren't implemented on the Mac yet. */
# endif
# if WANT_XWINDOWS
#  undef WANT_XWINDOWS
#  define WANT_XWINDOWS 0	/* X-Windows on the mac? Ha! */
# endif
# if !WANT_FIXED_HEAP
#  undef WANT_FIXED_HEAP
#  define WANT_FIXED_HEAP 1	/* MacOS doesn't return NULL pointers when out of memory. */
# endif
# if WANT_DLL_SUPPORT
#  undef WANT_DLL_SUPPORT
#  define WANT_DLL_SUPPORT 0	/* I don't know how to do DLLs on MacOS */
# endif
#endif

#endif
