/* $Id: float.c,v 1.4 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "prim.h"
#include "pair.h"
#include "float.h"
#include "string.h"

OBJECT float_class;

void init_float(void) {
    float_class = newclass(object_class, FLOAT_SIZE, NULL);
    register_root(&float_class, 1);
}

OBJECT newfloat(FLOAT val) {
    OBJECT obj = NewObject(float_class, 0, sizeof(FLOAT));

    SETFLOAT(obj, val);

    return obj;
}

/* Methods */

PRIVATE OBJECT float_printstr(OBJECT f, OBJECT w) {
  char buf[128];
  sprintf(buf, "%.10g", GETFLOAT(f));
  return newstring(buf);
}

#define AM(n,f,a)   addmeth(n,f,a,cl)

void init_meth_float(void) {
    OBJECT cl = NULL;
    temp_register(&cl, 1);
    cl = cons(float_class, NULL);

    AM("print-string", float_printstr, 2);

    deregister_root(1);
}

