/* $Id: gf.c,v 1.3 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "gf.h"
#include "prim.h"
#include "pair.h"
#include "function.h"

OBJECT gf_class;

void init_gf(void) {
    gf_class = newclass(object_class, GF_SIZE, NULL);
    register_root(&gf_class, 1);
}

OBJECT newgf(OBJECT name) {
    OBJECT gf = NewObject(gf_class, 0, 0);

    SET(gf, GF_NAME, name);
    SET(gf, GF_METHODS, NULL);

    return gf;
}

void addmethod(OBJECT gf, OBJECT method, OBJECT classlist) {
    OBJECT class = CAR(classlist);
    OBJECT super = GET(class, CLS_SUPER);
    OBJECT prev, meth;
    OBJECT R;

    temp_register(&R, 1);

    prev = NULL;
    meth = GET(gf, GF_METHODS);

    while (meth != NULL) {
        if (CAR(CAR(meth)) == class) {
            SETCDR(CAR(meth), method);
	    deregister_root(1);
            return;
        }

        prev = meth;
        meth = CDR(meth);
    }

    while (super != NULL) {
        prev = NULL;
        meth = GET(gf, GF_METHODS);

        while (meth != NULL) {
            if (CAR(CAR(meth)) == super) {
	      R = cons(class, method);
	      R = cons(R, meth);

	      if (prev == NULL)
		SET(gf, GF_METHODS, R);
	      else
		SETCDR(prev, R);

	      deregister_root(1);
	      return;
            }

            prev = meth;
            meth = CDR(meth);
        }

        super = GET(super, CLS_SUPER);
    }

    R = cons(class, method);
    R = cons(R, NULL);

    if (prev == NULL)
        SET(gf, GF_METHODS, R);
    else
        SETCDR(prev, R);

    deregister_root(1);
}

OBJECT matchmethods(OBJECT gf, OBJECT argvec, int argofs, OBJECT prevmethod) {
    OBJECT class = GETCLASS(IGET(argvec, argofs));
    OBJECT methref, meth;
    int accept_next = (prevmethod == NULL) ? 1 : 0;

    methref = meth = GET(gf, GF_METHODS);

    while (class != NULL) {
        if (methref == NULL)
            break;

        meth = methref;

        while (meth != NULL) {
            if (CAR(CAR(meth)) == class) {
                if (accept_next)
                    return CDR(CAR(meth));
                else if (CDR(CAR(meth)) == prevmethod)
                    accept_next = 1;

                methref = CDR(meth);
                break;
            }

            meth = CDR(meth);
        }

        class = GET(class, CLS_SUPER);
    }

    return NULL;
}

/* Methods */

PRIVATE OBJECT gf_addmethod(OBJECT gf, OBJECT classlist, OBJECT method) {
    addmethod(gf, method, classlist);

    if (debug_flag)
        fprintf(stderr, "Defining method on gf %s ",
            BIDX(GET(gf, GF_NAME), 0));

    if (instance(method, function_class)) {
        if (debug_flag && GET(method, FUNC_NAME) != NULL)
            fprintf(stderr, "(function _was_ called %s) ",
                BIDX(GET(method, FUNC_NAME), 0));

        SET(method, FUNC_NAME, GET(gf, GF_NAME));
    }

    if (debug_flag)
        fputc('\n', stderr);

    return method;
}

#define AM(n,f,a)   addmeth(n,f,a,cl)

void init_meth_gf(void) {
    OBJECT cl = NULL;
    temp_register(&cl, 1);
    cl = cons(gf_class, NULL);

    AM("add-method", gf_addmethod, 3);

    deregister_root(1);
}

