/* $Id: main.c,v 1.9 1998/08/15 13:02:38 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "buffer.h"
#include "scan.h"
#include "parse.h"
#include "compile.h"
#include "interp.h"
#include "string.h"
#include "thread.h"
#include "vector.h"
#include "symbol.h"
#include "prim.h"
#include "pair.h"

#include "patchlvl.h"
#include "config.h"

#include <signal.h>
#include <stdlib.h>

#ifdef __MWERKS__
# include <string.h>
# include <SIOUX.h>
#endif

#ifdef __TURBOC__
extern unsigned _stklen = 0x4000;   /* 16k stack */
#endif

#define MOOF_BANNER	"MOOF v" MOOF_VERSION " Copyright (C) 1994 through 1998 Tony Garnock-Jones"

#ifdef __MWERKS__

PRIVATE void banner(void) {
  char s[256];

  SIOUXSettings.columns = 100;
  SIOUXSettings.rows = 37;

  SIOUXSettings.toppixel = 240;	/* Put the window at some reasonable place. */
  SIOUXSettings.leftpixel = 205;

  SIOUXSettings.autocloseonquit = 1;
  SIOUXSettings.asktosaveonclose = 0;

  sprintf(s+1, MOOF_BANNER);
  s[0] = (char) strlen(s+1);	/* Pascal-style string. */

  printf("\n");		/* Because SIOUXSetTitle won't work unless some output has been written. */

  SIOUXSetTitle((unsigned char *) s);
}

#else /* not def __MWERKS__ */

PRIVATE void banner(void) {
  fprintf(stderr, MOOF_BANNER "\n\n");
}

#endif /* def __MWERKS__ */

PRIVATE void usage(void) {
    fprintf(stderr,
        "Usage: moof filename+ {filename|option}*\n"
        "\n"
        "  Where filename is a file of moof source-code to load, and option is one of:\n"
        "    -h             Displays this message\n"
        "    -snnnnnn       Sets heap size to nnnnnn bytes\n"
        "    -dnnn          Sets the internal debug flag to level nnn\n"
        "                   (0 = no debug info; the default)\n"
        "\n"
    );
}

PRIVATE void parse_command_line(int argc, char *argv[]) {
    long maxbytes = MAX_AVAIL_HEAP;
    int dflag = 0;

    while (argc > 0) {
        argc--;

        if (*argv[argc] == '-') {
            switch (argv[argc][1]) {
                case '-':
                    *argv[argc] = '\0';
                    init_memory(maxbytes, dflag);
                    return;

                case 'h':
                    usage();
                    break;

                case 's':
                    maxbytes = atol(argv[argc] + 2);
                    break;

                case 'd':
                    dflag = atoi(argv[argc] + 2);
                    break;

                default:
                    continue;
            }

            *argv[argc] = '\0';
        }
    }

    init_memory(maxbytes, dflag);
}

PRIVATE void moof_signal_handler(int signum) {
    signal_raised = MKNUM(signum);
                                /* Don't allocate any objects, it might */
                                /* not be safe here. */

    /* To cope with multiple signals being raised, make signal_raised
       a bitmap instead of the number of the most recent signal; then
       no signals should be lost (?) */

    signal(signum, moof_signal_handler);
}

int main(int argc, char *argv[]) {
    word i;

    if (argc < 2)
      banner();

    signal(SIGINT, moof_signal_handler);
    signal(SIGTERM, moof_signal_handler);

    /* These signals are not supported under DOS or Win32 */
    signal(SIGHUP, moof_signal_handler);
    signal(SIGQUIT, moof_signal_handler);
    signal(SIGUSR1, moof_signal_handler);
    signal(SIGUSR2, moof_signal_handler);
    signal(SIGALRM, moof_signal_handler);

    parse_command_line(argc - 1, argv + 1);

    {
        OBJECT org, prev;

        org = prev = NULL;
        temp_register(&org, 1);

        for (i=1; i<argc; i++)
            if (*argv[i] != '\0')
                if (prev == NULL)
                    org = prev = cons(newstring(argv[i]), NULL);
                else {
                    SETCDR(prev, cons(newstring(argv[i]), NULL));
                    prev = CDR(prev);
                }

        SET(newsym("*command-line*"), SYM_VALUE, listtovect(org));

        deregister_root(1);
    }

    {
      char *str = getenv("MOOF_LIBDIR");

      if (str == NULL)
	str = MOOF_LIBDIR;

      SET(newsym("*library-directory*"), SYM_VALUE, newstring(str));
    }

    {
        OBJECT thread = newthread();
	char *startup_filename = getenv("MOOF_BOOTFILE");

	if (startup_filename == NULL)
	  startup_filename = MOOF_BOOTFILE;

        push_call(thread, newprim(1, newsym("startup-loader"), string_load),
                  NULL, newvector(1, 1, newstring(startup_filename)));

        unblock(thread);

        thread = schedule();
        while (thread != NULL) {
            if (interp(thread, (int) NUM(GET(thread, THR_QUANTUM))) == true)
                block(thread);  /* So it will be collected */

            thread = schedule();
        }
    }

    return 0;
}
