/* $Id: misc.c,v 1.13 1998/08/15 13:02:38 tonyg Exp $ */

#include "memory.h"
#include "symbol.h"
#include "prim.h"
#include "misc.h"
#include "compile.h"
#include "interp.h"
#include "pair.h"
#include "class.h"
#include "thread.h"
#include "vector.h"
#include "patchlvl.h"

#include <stdlib.h>
#include <stdio.h>
#include <time.h>

PRIVATE OBJECT misc_gc(void) {
    gc();
    return NULL;
}

PRIVATE OBJECT misc_debuglevel(OBJECT args) {
    if (args == NULL)
        return MKNUM(debug_flag);
    else {
        debug_flag = (int) NUM(CAR(args));
        return MKNUM(debug_flag);
    }
}

PRIVATE OBJECT misc_system(OBJECT command) {
    return MKNUM(-1);
}

PRIVATE OBJECT misc_raise(OBJECT exception, OBJECT args) {
    raise_exception(BIDX(exception, 0), args);
    return NULL;
}

PRIVATE OBJECT misc_provided(OBJECT what) {
  OBJECT features = GET(newsym("*features*"), SYM_VALUE);

  while (features != NULL) {
    if (CAR(features) == what)
      return true;

    features = CDR(features);
  }

  return false;
}

PRIVATE OBJECT misc_nullp(OBJECT x) {
  return (x == NULL) ? true : false;
}

PRIVATE OBJECT misc_not(OBJECT x) {
  return (x == false) ? true : false;
}

PRIVATE OBJECT misc_listlength(OBJECT l) {
  long length = 0;
  OBJECT curr = l;

  while (curr != NULL) {
    if (instance(curr, pair_class)) {
      length++;
      curr = CDR(curr);
      continue;
    }

    raise_exception("improper-list-in-list-length", l);
    return NULL;
  }

  return MKNUM(length);
}

PRIVATE OBJECT misc_foreach1(OBJECT func, OBJECT list) {
  if (list == NULL)
    return undefined;
  else {
    OBJECT vec = NULL;
    temp_register(&vec, 1);

    vec = newvector(2, 1, func, CDR(list));
    push_call(getcurrthr(), GET(newsym("for-each1"), SYM_VALUE), NULL, vec);

    vec = cons(CAR(list), NULL);
    vec = cons(vec, NULL);	/* Because apply needs a list in the last position. */

    deregister_root(1);

    return interp_apply(func, vec);
  }
}

PRIVATE OBJECT misc_memq(OBJECT what, OBJECT in) {
  while (in != NULL) {
    if (CAR(in) == what)
      return in;

    in = CDR(in);
  }

  return false;
}

PRIVATE OBJECT misc_assq(OBJECT what, OBJECT in) {
  while (in != NULL) {
    if (instance(CAR(in), pair_class)) {
      if (CAR(CAR(in)) == what)
	return CAR(in);
    }

    in = CDR(in);
  }

  return false;
}

PRIVATE OBJECT misc_set_critsec(OBJECT state) {
  int old_state = interp_critsec;

  if (state == false)
    interp_critsec = 0;
  else
    interp_critsec = 1;

  return (old_state == 0) ? false : true;
}

PRIVATE OBJECT misc_srandom(OBJECT seed) {
  srandom(NUM(seed));
  return undefined;
}

PRIVATE OBJECT misc_random(void) {
  return MKNUM(random());
}

PRIVATE OBJECT misc_time(void) {
  return MKNUM(time(NULL));
}

#if WANT_DLL_SUPPORT
#include <dlfcn.h>

PRIVATE OBJECT misc_import_dll(OBJECT filename, OBJECT argument) {
  void *handle = dlopen(BIDX(filename, 0), RTLD_NOW);
  OBJECT (*fcn)(OBJECT arg);

  if (handle == NULL)
    return undefined;

  fcn = dlsym(handle, "MOOF_initdll");

  if (fcn == NULL)
    return NULL;

  return fcn(argument);
}
#endif

#if WANT_OSS_SOUND_SUPPORT
#include <linux/soundcard.h>
#include <sys/types.h>
#include <sys/ioctl.h>

#define GETFP(o)    (* ((FILE **) BIDX(o, 0)))

PRIVATE OBJECT misc_oss_dsp_configure(OBJECT file, OBJECT bits, OBJECT rate) {
  FILE *f = GETFP(file);
  int fd = fileno(f);

  ho hum...
}
#endif

#define RP(n,f,a)       addprim(n,f,a)

void init_meth_misc(void) {
    RP("garbage-collect!", misc_gc, 0);
    RP("compile", compile, 1);
    RP("apply", interp_apply, -2);
    RP("debug-level", misc_debuglevel, -1);
    RP("system", misc_system, 1);
    RP("raise-exception", misc_raise, 2);
    RP("provided?", misc_provided, 1);
    RP("null?", misc_nullp, 1);
    RP("not", misc_not, 1);
    RP("list-length", misc_listlength, 1);
    RP("for-each1", misc_foreach1, 2);
    RP("memq", misc_memq, 2);
    RP("assq", misc_assq, 2);
    RP("set-critical-section-flag!", misc_set_critsec, 1);
    RP("seed-random", misc_srandom, 1);
    RP("random", misc_random, 0);
    RP("system-time", misc_time, 0);

#if WANT_OSS_SOUND_SUPPORT
    RP("oss-dsp-configure", misc_oss_dsp_configure, 3);
    {
      OBJECT fsym = NULL;
      OBJECT cl = NULL;

      temp_register(&fsym, 1);
      temp_register(&cl, 1);

      fsym = newsym("*features*");
      cl = newsym("oss-sound");
      cl = cons(cl, GET(fsym, SYM_VALUE));
      SET(fsym, SYM_VALUE, cl);

      deregister_root(2);
    }
#endif

#if WANT_DLL_SUPPORT
    RP("import-dll", misc_import_dll, 2);
    {
      OBJECT fsym = NULL;
      OBJECT cl = NULL;

      temp_register(&fsym, 1);
      temp_register(&cl, 1);

      fsym = newsym("*features*");
      cl = newsym("dll-support");
      cl = cons(cl, GET(fsym, SYM_VALUE));
      SET(fsym, SYM_VALUE, cl);

      deregister_root(2);
    }
#endif

#ifdef unix
    SET(newsym("*system-type*"), SYM_VALUE, newsym("unix"));
#else
# ifdef __TURBOC__
    SET(newsym("*system-type*"), SYM_VALUE, newsym("msdos"));
# else
#  ifdef __MWERKS__
    SET(newsym("*system-type*"), SYM_VALUE, newsym("macos"));
#  else
    SET(newsym("*system-type*"), SYM_VALUE, newsym("unknown"));
#  endif
# endif
#endif

    SET(newsym("*version*"), SYM_VALUE, newsym("moof-" MOOF_VERSION));

}
