/* $Id: thread.h,v 1.2 1998/04/05 10:33:48 tonyg Exp $ */

#ifndef Thread_H
#define Thread_H

extern OBJECT thread_class;
extern OBJECT continuation_class;

extern void init_thread(void);
extern void init_meth_thread(void);

#define THR_SIZE            12
#define THR_STACK_MAX       256 /* Max depth of stack per thread - 1K stack */

#define THR_CONT            0   /* Partial continuation */
#define THR_IP              1   /* Instruction pointer */
#define THR_ENV             2   /* Environment register */
#define THR_ACC             3   /* Accumulator */
#define THR_FUNC            4   /* Currently executing code */
#define THR_CURR_GF         5   /* Generic Function currently active */
#define THR_STACK_DEPTH     6   /* Current depth-of-stack */
#define THR_QUANTUM         7   /* Quantum limit for thread */
#define THR_STATUS          8   /* Is thread runnable? */
#define THR_NEXT            9
#define THR_PREV            10
#define THR_HANDLER_CHAIN   11  /* List of exception handlers */

#define CONT_SIZE           3

#define CONT_CONT           0   /* Partial continuation */
#define CONT_STACK          1   /* Contents of stack */
#define CONT_HANDLER_CHAIN  2   /* Exception handlers */

extern OBJECT newthread(void);
extern OBJECT getcurrthr(void);

extern OBJECT getcont(OBJECT thread);
extern void setcont(OBJECT thread, OBJECT cont);

    /* Note: getcont doesn't save the values of the thread's registers.
             Use push_call or something to do that. */

extern void stack_push(OBJECT thread, OBJECT value);
extern OBJECT stack_pop(OBJECT thread);
extern word stack_depth(OBJECT thread);

#define CTXT_SIZE           5

#define CTXT_NEXT           0   /* Remainder of partial continuation */
#define CTXT_IP             1   /* Saved IP */
#define CTXT_ENV            2   /* Saved ENV */
#define CTXT_FUNC           3   /* Saved FUNC */
#define CTXT_CURR_GF        4   /* Saved CURR_GF */

extern void apply(OBJECT thread, OBJECT function, OBJECT curr_gf, OBJECT env);
extern void push_call(OBJECT thread, OBJECT function,
                      OBJECT curr_gf, OBJECT env);
extern void pop_call(OBJECT thread);

extern void raise_exception(char *exception, OBJECT args);

extern void unblock_priority(OBJECT thread);
extern void unblock(OBJECT thread);
extern void block(OBJECT thread);
extern OBJECT schedule(void);

extern void dump_context_on(FILE *f, OBJECT cont);

    /* Use cont = NULL if you want the continuation from currthr */

#endif
