/* $Id: vector.c,v 1.3 1998/04/05 10:33:48 tonyg Exp $ */

#include "memory.h"
#include "class.h"
#include "vector.h"
#include "pair.h"

#include <string.h>
#include <stdarg.h>

OBJECT vector_class;

void init_vector(void) {
  vector_class = NULL;
  register_root(&vector_class, 1);
  vector_class = newclass(object_class, VECT_SIZE, NULL);
}

void init_meth_vector(void) {
}

OBJECT newvector(long length, int init, ...) {
    OBJECT vec = NewObject(vector_class, (word) length, 0);

    if (init) {
        va_list vl;
        word i;

        va_start(vl, init);
        for (i=0; i<(word)length; i++)
            ISET(vec, i, va_arg(vl, OBJECT));
        va_end(vl);
    }

    return vec;
}

OBJECT listtovect(OBJECT list) {
    word len = (word) list_length(list);
    OBJECT vec = newvector(len, 0);
    word i;

    for (i=0; i<len; i++) {
        ISET(vec, i, CAR(list));
        list = CDR(list);
    }

    return vec;
}
