        .model  large
        .data

        extrn   _curproc:dword

        .code

        extrn   _do_fork:far
        extrn   _do_swap:far
        extrn   _do_exit:far

        public  _fork, _swap, _exit_proc, _restore_state

kstklen equ     256
krnlstk db      kstklen dup (?)         ; kernel stack

ds_save dw      ?
bx_save dw      ?

_save_state:
        pushf
        cli
        push    ds
        push    bx

        push    ds
        pop     ds_save
        lds     bx,_curproc

        pop     [bx+2]
        pop     [bx+18]
        pop     [bx+26]

        mov     [bx],ax
        pop     ax                      ; AX -> near return address
        pop     [bx+24]                 ; Pop IP
        pop     [bx+16]                 ; Pop CS

        mov     [bx+4],cx
        mov     [bx+6],dx
        mov     [bx+8],si
        mov     [bx+10],di
        mov     [bx+12],bp
        mov     [bx+14],sp
        mov     [bx+20],es
        mov     [bx+22],ss

        push    ds_save
        pop     ds

        mov     bx,cs                   ; krnlstk is in CS
        mov     ss,bx
        mov     sp,offset krnlstk + kstklen

        push    ax
        ret

_restore_state  proc    far
        lds     bx,_curproc

        mov     ax,[bx+2]
        mov     bx_save,ax

        mov     ax,[bx]
        mov     cx,[bx+4]
        mov     dx,[bx+6]
        mov     si,[bx+8]
        mov     di,[bx+10]
        mov     bp,[bx+12]
        mov     sp,[bx+14]
        mov     es,[bx+20]
        mov     ss,[bx+22]

        push    [bx+26]
        push    [bx+16]
        push    [bx+24]

        mov     ds,[bx+18]
        mov     bx,bx_save

        iret
_restore_state  endp

_fork   proc    far
        call    _save_state             ; Removes CS and IP from stack

        les     bx,_curproc
        mov     si,es:[bx+14]
        mov     es,es:[bx+22]           ; ES:SI -> stack of process

        push    es:[si+8]               ; Push stksize
        push    es:[si+6]               ; Push arg (hi word)
        push    es:[si+4]               ; Push arg (lo word)
        push    es:[si+2]               ; Push proc (segment)
        push    es:[si]                 ; Push proc (offset)

        call    _do_fork

        les     bx,_curproc
        mov     es:[bx],ax              ; Save return value (AX, lo word)
        mov     es:[bx+6],dx            ; Save return value (DX, hi word)

        jmp     _restore_state
_fork   endp

_swap   proc    far
        call    _save_state
        call    _do_swap
        jmp     _restore_state
_swap   endp

_exit_proc      proc    far
        call    _save_state
        call    _do_exit
        jmp     _restore_state
_exit_proc      endp

        end

