#include "oom.h"

#include <stdlib.h>
#include <mem.h>

/* =================== SHARED GLOBALS */

int shutting_down;
OBJECT shutdown_tasks;

/* =================== */

#define FP_SEG(p)   ((word) (((long) p) >> 16))
#define FP_OFS(p)   ((word) (((long) p) & 0xFFFF))

PRIVATE PROCESS proctab;
PRIVATE int proccount;

PROCESS curproc;
PROCINFO curinfo;

PROCINFO do_fork(void (*proc)(), void *arg, word stksize) {
    PROCESS x; 
    int *stk;

    x = getmem(sizeof(_process));

    memset(&(x->regs), 0, 28);

    x->stack.base = getmem(stksize);
    x->stack.top = (void *) (((char *) x->stack.base) + stksize);
    x->stack.size = stksize;

    x->regs.cs = FP_SEG(proc);
    x->regs.ip = FP_OFS(proc);
    x->regs.ds = _DS;
    x->regs.es = _ES;
    x->regs.ss = FP_SEG(x->stack.top);
    x->regs.sp = FP_OFS(x->stack.top) - 8;
    x->regs.flags = 0x0200;

    stk = (int *) (((char *) x->stack.top) - 8);
    stk[0] = FP_OFS(exit_proc);
    stk[1] = FP_SEG(exit_proc);
    stk[2] = FP_OFS(arg);
    stk[3] = FP_SEG(arg);

    x->info = getmem(sizeof(_procinfo));
    if (curproc->info == NULL)
        memset(x->info, 0, sizeof(_procinfo));
    else
        memcpy(x->info, curproc->info, sizeof(_procinfo));

    x->regs.ax = FP_OFS(x->info);
    x->regs.dx = FP_SEG(x->info);

    x->next = proctab;
    proctab = x;
    proccount++;

    return x->info;
}

void do_swap(void) {
    if (curproc->regs.sp <= FP_OFS(curproc->stack.base))
        fatal("Stack pointer too low %d",curproc->regs.sp);
    curproc = curproc->next;
    if (curproc == NULL) curproc = proctab;
    curinfo = curproc->info;
}

void do_exit(void) {
    PROCESS prev, curr;

    if (curproc->next == NULL) exit(0);

    prev = NULL;
    curr = proctab;

    while (curr != NULL) {
        if (curr == curproc) {
            if (prev != NULL) prev->next = curr->next; else
                              proctab = curr->next;
            curproc = curr->next;
            curinfo = curproc->info;
            proccount--;
            freemem(curr->info);
            freemem(curr->stack.base);
            freemem(curr);
            restore_state();
            /* Execution never passes here */
        }
        prev = curr;
        curr = curr->next;
    }
}

PROCESS getcurproc(void) {
    return curproc;
}

PROCESS getproclist(void) {
    return proctab;
}

int getproccount(void) {
    return proccount;
}

void init_process(void) {
    shutting_down = 0;
    shutdown_tasks = NULL;

    curproc = proctab = getmem(sizeof(_process));
    curinfo = curproc->info = getmem(sizeof(_procinfo));
    memset(curproc, 0, sizeof(_process));
        /* Root process' stack is set to NULL. */
    memset(curinfo, 0, sizeof(_procinfo));
    proccount = 1;
}

