#ifndef __PROCESS_H
#define __PROCESS_H

#include <setjmp.h>

/* ================== GLOBALS SHARED BETWEEN PROCESSES */

extern int shutting_down;           /* System is trying to quit */
extern OBJECT shutdown_tasks;       /* Tasks to be revived at next load */

/* ================== */

typedef struct __procinfo *PROCINFO;
typedef struct __procinfo {
    OBJECT player;      /* This process' player */
    OBJECT code_owner;  /* The currently effective player */
    OBJECT caller;      /* Player-caller of current routine */
    OBJECT conn;        /* This process' connection */
    OBJECT stack;       /* This process' interp object stack */
    OBJECT errstk;      /* List of error-handlers */
    jmp_buf errjmp;     /* Resumption address for this process */
    int errjmp_ok;      /* Resumption address is valid */
    long task_id;       /* Number of this task */
    long ticks_left;    /* Ticks left before process is killed */
    int logging_in;     /* True if this task is in its login procedure */
} _procinfo;

typedef struct __process *PROCESS;
typedef struct __process {
    struct {
        word ax,bx,cx,dx;   /* 0  2  4  6  */
        word si,di,bp,sp;   /* 8  10 12 14 */
        word cs,ds,es,ss;   /* 16 18 20 22 */
        word ip,flags;      /* 24 26       */
    } regs;
    struct {
        void *base;         /* Low in memory */
        void *top;          /* High in memory */
        word size;
    } stack;
    PROCESS next;
    PROCINFO info;
} _process;

extern PROCESS curproc;
extern PROCINFO curinfo;

extern PROCINFO fork(void (*proc)(), void *arg, long stksize);
extern void swap(void);
extern void exit_proc(void);
extern void restore_state(void);
extern PROCESS getcurproc(void);
extern PROCESS getproclist(void);
extern int getproccount(void);

extern void init_process(void);

#endif
