#ifndef __BYTECODE_H
#define __BYTECODE_H

#define OP_CONST_NUM        0x00    /* OP long */
#define OP_CONST_STR        0x01    /* OP asciiz */
#define OP_CONST_SYM        0x02    /* OP asciiz */
#define OP_CONST_FUNCTION   0x03    /* OP char-argc word-blklen code... */
#define OP_CONST_OBJECT     0x04    /* OP long-object-number */
#define OP_CONST_NULL       0x05    /* OP */
#define OP_CONST_TRUE       0x06    /* OP */
#define OP_CONST_FALSE      0x07    /* OP */

#define OP_REF_LOCAL        0x10    /* OP word-scope word-ofs */
#define OP_REF_PRIM         0x11    /* OP word-primnum */
#define OP_REF_SLOT         0x12    /* OP asciiz */
#define OP_REF_PARENT       0x13    /* OP */
#define OP_REF_METHOD       0x14    /* OP asciiz */
#define OP_SET_LOCAL        0x15    /* value OP word-scope word-ofs */
#define OP_SET_SLOT         0x16    /* value OP asciiz */
#define OP_DEF_SLOT         0x17    /* object value OP asciiz */
#define OP_DEF_METHOD       0x18    /* object value OP asciiz */

#define OP_CALL             0x20    /* function args... OP char-argc */
#define OP_PRE_METHCALL     0x21    /* OP */
#define OP_CALL_METHOD      0x22    /* obj self args.. OP char-argc methname */
#define OP_FORK_AFTER       0x23    /* thunk OP long-num-seconds */
#define OP_RET              0x24    /* OP */

#define OP_POP              0x30    /* value OP */
#define OP_DUP              0x31    /* value OP */

#define OP_ENTER_SCOPE      0x40    /* OP word-num-entries */
#define OP_LEAVE_SCOPE      0x41    /* OP */

#define OP_CONS             0x50    /* car cdr OP */
#define OP_NCONS            0x51    /* values... null OP word-times-to-cons */

#define OP_JUMP             0x60    /* OP rel-ofs */
#define OP_JUMP_TRUE        0x61    /* OP rel-ofs */
#define OP_JUMP_FALSE       0x62    /* OP rel-ofs */
#define OP_JUMP_NULL        0x63    /* OP rel-ofs */

#define OP_NOT              0x70    /* x OP */
#define OP_OR               0x71    /* a b OP */
#define OP_AND              0x72    /* a b OP */
#define OP_EQ               0x73    /* a b OP */
#define OP_NE               0x74    /* a b OP */
#define OP_GT               0x75    /* a b OP */
#define OP_LT               0x76    /* a b OP */
#define OP_GE               0x77    /* a b OP */
#define OP_LE               0x78    /* a b OP */

#define OP_PLUS             0x80    /* a b OP */
#define OP_MINUS            0x81    /* a b OP */
#define OP_STAR             0x82    /* a b OP */
#define OP_SLASH            0x83    /* a b OP */
#define OP_PERCENT          0x84    /* a b OP */

#endif
