#include "oom.h"

#include "com.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>

/* From DOS.H (reason dos.h not included is namespace conflicts) */

void _Cdecl setvect(int interruptno, void interrupt (*isr)());
void interrupt (* _Cdecl getvect(int interruptno))();
void _Cdecl __sti__(void);
unsigned char _Cdecl __inportb__(int portid);
void _Cdecl __outportb__(int portid, unsigned char value);
#define enable()                __sti__()
#define inportb(portid)         __inportb__(portid)
#define outportb(portid,v)      __outportb__(portid,v)

#define READ                    0       /* Reg to read from */
#define WRITE                   0       /* Reg to write to */
#define IRQ                     1       /* Reg holding IRQ info */
#define IRQ_TYPE                2       /* Reg holding "what type of IRQ" */
#define LINE_CONTROL            3       /* Line control register */
#define MODEM_CONTROL           4       /* Modem control register */
#define LINE_STATUS             5       /* Line status register */
#define MODEM_STATUS            6       /* Modem status register */

#define IRQ_ENABLE_READ         0x01    /* Enables IRQ on receive */
#define IRQ_ENABLE_WRITE        0x02    /* Enables IRQ on txmit buffer empty */

#define IRQ_MSTAT_INT           0x00    /* IRQ ID for Modem Status int. */
#define IRQ_WRITE_INT           0x02    /* IRQ ID for ready to write */
#define IRQ_READ_INT            0x04    /* IRQ ID for character incoming */
#define IRQ_LSTAT_INT           0x06    /* IRQ ID for line status change */

#define DIVISOR_LATCH           0x80    /* Bit to set when setting baud */
#define P_EVEN                  0x08    /* Even parity */
#define P_ODD                   0x18    /* Odd parity */
#define P_NONE                  0x00    /* No parity */
#define STOP_1                  0x00    /* One stop bit */
#define STOP_2                  0x04    /* Two stop bits */
#define DATA_5                  0x00    /* 5 data bits */
#define DATA_6                  0x01    /* 6 data bits */
#define DATA_7                  0x02    /* 7 data bits */
#define DATA_8                  0x03    /* 8 data bits */

#define DTR                     0x01    /* In MODEM_CONTROL, turns on DTR */
#define RTS                     0x02    /* Turns on RTS */
#define OUT1                    0x04    /* Turns on OUT1 */
#define OUT2                    0x08    /* Turns on OUT2 */

#define CARRIER                 0x80    /* In LINE_STATUS, 1 if carrier */

#define DIVISOR_LSB             0       /* Output when sending LSB */
#define DIVISOR_MSB             1       /* Output when sending MSB */

#define IRQ_CONTROLLER          0x20    /* Port number of 8259 */
#define IRQ_MASK_REG            0x21    /* Port number of irq-masker */
#define EOI                     0x20    /* End of interrupt command */

PRIVATE COMPORT comports[2] = { NULL, NULL };

#define COM1_UART               0x3F8
#define COM2_UART               0x2F8

#define COM1_IRQ                4
#define COM2_IRQ                3
#define IRQ_BASE                8

PRIVATE void interrupt isr_com1(void) {
    unsigned char ch;
    COMPORT port = comports[0];

    enable();
    while (1) {
        switch (inportb(COM1_UART + IRQ_TYPE)) {
            case IRQ_MSTAT_INT:
                inportb(COM1_UART + MODEM_STATUS);
                break;
            case IRQ_WRITE_INT:
                if (port->out.r_idx == port->out.w_idx)
                    outportb(COM1_UART + IRQ, IRQ_ENABLE_READ); else {
                        outportb(COM1_UART + WRITE,
                            port->out.buf[port->out.r_idx++]);
                        port->out.r_idx %= IOBUFLEN;
                    }
                break;
            case IRQ_READ_INT:
                ch = (unsigned char) inportb(COM1_UART + READ);
                if (port->in.w_idx + 1 != port->in.r_idx) {
                    port->in.buf[port->in.w_idx++] = ch;
                    port->in.w_idx %= IOBUFLEN;
                }
                break;
            case IRQ_LSTAT_INT:
                inportb(COM1_UART + LINE_STATUS);
                break;
            default:
                outportb(IRQ_CONTROLLER, EOI);
                return;
        }
    }
}

PRIVATE void interrupt isr_com2(void) {
    unsigned char ch;
    COMPORT port = comports[1];

    enable();
    while (1) {
        switch (inportb(COM2_UART + IRQ_TYPE)) {
            case IRQ_MSTAT_INT:
                inportb(COM2_UART + MODEM_STATUS);
                break;
            case IRQ_WRITE_INT:
                if (port->out.r_idx == port->out.w_idx)
                    outportb(COM2_UART + IRQ, IRQ_ENABLE_READ); else {
                        outportb(COM2_UART + WRITE,
                            port->out.buf[port->out.r_idx++]);
                        port->out.r_idx %= IOBUFLEN;
                    }
                break;
            case IRQ_READ_INT:
                ch = (unsigned char) inportb(COM2_UART + READ);
                if (port->in.w_idx + 1 != port->in.r_idx) {
                    port->in.buf[port->in.w_idx++] = ch;
                    port->in.w_idx %= IOBUFLEN;
                }
                break;
            case IRQ_LSTAT_INT:
                inportb(COM2_UART + LINE_STATUS);
                break;
            default:
                outportb(IRQ_CONTROLLER, EOI);
                return;
        }
    }
}

COMPORT newcomport(int portnum, long baud, int data, int parity, int stop) {
    COMPORT port;
    int intnum = ((portnum == 1) ? COM1_IRQ : COM2_IRQ);
    int uart = ((portnum == 1) ? COM1_UART : COM2_UART);
    int i;

    port = getmem(sizeof(_comport));
    comports[portnum-1] = port;

    port->in.w_idx = port->in.r_idx = port->out.w_idx = port->out.r_idx = 0;
    port->portnum = portnum;
    port->old_vector = getvect(intnum + IRQ_BASE);
    setvect(intnum + IRQ_BASE, (portnum == 1) ? isr_com1 : isr_com2);

    i = inportb(IRQ_MASK_REG);
    outportb(IRQ_MASK_REG, i & ~(1 << intnum));

    outportb(uart + IRQ, 0);
    inportb(uart + READ);

    i = (word) (115200L / baud);
    outportb(uart + LINE_CONTROL, DIVISOR_LATCH);
    outportb(uart + DIVISOR_LSB, i & 0xFF);
    outportb(uart + DIVISOR_MSB, i >> 8);
    outportb(uart + LINE_CONTROL, 0);

    switch (parity) {
        case 'e':
        case 'E':
            i = P_EVEN;
            break;
        case 'o':
        case 'O':
            i = P_ODD;
            break;
        default:
            i = P_NONE;
    }

    if (stop == 2)
        i |= STOP_2; else
        i |= STOP_1;

    switch (data) {
        case 5: i |= DATA_5; break;
        case 6: i |= DATA_6; break;
        case 7: i |= DATA_7; break;
        case 8: i |= DATA_8; break;
    }

    outportb(uart + LINE_CONTROL, i);
    outportb(uart + MODEM_CONTROL, DTR | RTS | OUT2);
    outportb(uart + IRQ, IRQ_ENABLE_READ);

    return port;
}

void killcomport(COMPORT port) {
    int uart = ((port->portnum == 1) ? COM1_UART : COM2_UART);
    int intnum = ((port->portnum == 1) ? COM1_IRQ : COM2_IRQ);
    int i;

    outportb(uart + IRQ, 0);
    i = inportb(IRQ_MASK_REG);
    outportb(IRQ_MASK_REG, i | (1 << intnum));
    setvect(IRQ_BASE + intnum, port->old_vector);
    outportb(uart + MODEM_CONTROL, 0);
    freemem(port);
}

int comport_tx_ready(COMPORT port) {
    return ((port->out.w_idx + 1) % IOBUFLEN) != port->out.r_idx;
}

void comport_putc(int ch, COMPORT port) {
    int uart = ((port->portnum == 1) ? COM1_UART : COM2_UART);

    while (((port->out.w_idx + 1) % IOBUFLEN) == port->out.r_idx) ;
        /* IRQs will fix this */
    port->out.buf[port->out.w_idx++] = ch;
    port->out.w_idx %= IOBUFLEN;
    if ((inportb(uart + IRQ) & IRQ_ENABLE_WRITE) == 0)
        outportb(uart + IRQ, IRQ_ENABLE_READ | IRQ_ENABLE_WRITE);
}

int comport_avail(COMPORT port) {
    return port->in.w_idx != port->in.r_idx;
}

int comport_getc(COMPORT port) {
    int ch;
    while (port->in.w_idx == port->in.r_idx) ; /* IRQs will fix this */
    ch = port->in.buf[port->in.r_idx++];
    port->in.r_idx %= IOBUFLEN;
    return ch;
}

int comport_carrier(COMPORT port) {
    int uart = ((port->portnum == 1) ? COM1_UART : COM2_UART);
    return (inportb(uart + MODEM_STATUS) & CARRIER) != 0;
}

void comport_setdtr(COMPORT port, int setting) {
    int uart = ((port->portnum == 1) ? COM1_UART : COM2_UART);
    int i;
    i = inportb(uart + MODEM_CONTROL);
    if (setting) outportb(uart + MODEM_CONTROL, i | DTR); else
                 outportb(uart + MODEM_CONTROL, i & ~DTR);
}

