#ifndef __COM_H
#define __COM_H

#define IOBUFLEN 256

typedef struct __iobuffer {
    char buf[IOBUFLEN];
    unsigned char r_idx, w_idx;
} _iobuffer, *IOBUFFER;

typedef struct __comport {
    void (interrupt *old_vector)();
    int portnum;
    _iobuffer in, out;
} _comport, *COMPORT;

extern COMPORT newcomport(int portnum, long baud, int data,
                          int parity, int stop);
extern void killcomport(COMPORT port);

int comport_tx_ready(COMPORT port);
void comport_putc(int ch, COMPORT port);
int comport_avail(COMPORT port);
int comport_getc(COMPORT port);

int comport_carrier(COMPORT port);
void comport_setdtr(COMPORT port, int setting);

#endif
