#include "oom.h"

#include "console.h"
#include "file.h"
#include "serial.h"
#include "string.h"

#include <stdio.h>
#include <stdarg.h>

_connection connections[] = {
    {
        console_startup,
        console_shutdown,

        console_open,
        console_close,
        console_reset,
        console_disconnect,

        console_dump,
        console_load,

        console_mark,

        console_getc,
        console_putc,
        console_ungetc,

        console_ready,
        console_eof
    },
    {
        file_startup,
        file_shutdown,

        file_open,
        file_close,
        file_reset,
        file_disconnect,

        file_dump,
        file_load,

        file_mark,

        file_getc,
        file_putc,
        file_ungetc,

        file_ready,
        file_eof
    },
    {
        serial_startup,
        serial_shutdown,

        serial_open,
        serial_close,
        serial_reset,
        serial_disconnect,

        serial_dump,
        serial_load,

        serial_mark,

        serial_getc,
        serial_putc,
        serial_ungetc,

        serial_ready,
        serial_eof
    },
    {
        string_startup,
        string_shutdown,

        string_open,
        string_close,
        string_reset,
        string_disconnect,

        string_dump,
        string_load,

        string_mark,

        string_getc,
        string_putc,
        string_ungetc,

        string_ready,
        string_eof
    }
};

void c_reset(OBJECT conn) {
    connections[GETCTYPE(conn)].reset(conn);
}

void c_disconnect(OBJECT conn) {
    connections[GETCTYPE(conn)].disconnect(conn);
}

int c_getc(OBJECT conn) {
    return connections[GETCTYPE(conn)].get(conn);
}

void c_putc(int ch, OBJECT conn) {
    connections[GETCTYPE(conn)].put(ch, conn);
}

void c_ungetc(int ch, OBJECT conn) {
    connections[GETCTYPE(conn)].unget(ch, conn);
}

int c_ready(OBJECT conn) {
    return connections[GETCTYPE(conn)].ready(conn);
}

int c_eof(OBJECT conn) {
    return connections[GETCTYPE(conn)].eof(conn);
}

void c_puts(char *s, OBJECT conn) {
    int type = GETCTYPE(conn);
    while (*s != '\0') connections[type].put(*s++, conn);
}

void c_printf(OBJECT conn, char *fmt, ...) {
    va_list vl;
    char s[256];
    char *p = s;
    void (*putter)(int ch, OBJECT conn);

    va_start(vl,fmt);
    vsprintf(s, fmt, vl);
    va_end(vl);

    putter = connections[GETCTYPE(conn)].put;
    while (*p != '\0') putter(*p++, conn);
}

void format(char *fmt, ...) {
    va_list vl;
    char s[256];
    char *p = s;
    void (*putter)(int ch, OBJECT conn);

    va_start(vl,fmt);
    vsprintf(s, fmt, vl);
    va_end(vl);

    putter = connections[GETCTYPE(curinfo->conn)].put;
    while (*p != '\0') putter(*p++, curinfo->conn);
}

void init_connect(void) {
    int i;

    for (i=0; i<MAX_CONNECTION_TYPES; i++)
        connections[i].startup();
}

void done_connect(void) {
    int i;

    for (i=0; i<MAX_CONNECTION_TYPES; i++)
        connections[i].shutdown();
}

