#ifndef __CONNECT_H
#define __CONNECT_H

#include <stdio.h>
#include <stdarg.h>

typedef struct __connection *CONNECTION;
typedef struct __connection {
    void (*startup)(void);          /* Called by init_connect */
    void (*shutdown)(void);         /* Called by done_connect */

    void (*open)(OBJECT conn);
    void (*close)(OBJECT conn);
    void (*reset)(OBJECT conn);
    void (*disconnect)(OBJECT conn);

    void (*dump)(OBJECT conn, FILE *f);
    void (*load)(OBJECT conn, FILE *f);

    void (*mark)(OBJECT conn);

    int (*get)(OBJECT conn);
    void (*put)(int ch, OBJECT conn);
    void (*unget)(int ch, OBJECT conn);

    int (*ready)(OBJECT conn);
    int (*eof)(OBJECT conn);
} _connection;

#define MAX_CONNECTION_TYPES    4

#define CONN_CONSOLE            0   /* Reads from console */
#define CONN_FILE               1   /* Reads from a file */
#define CONN_SERIAL             2   /* Reads from a serial port */
#define CONN_STRING             3   /* Reads from a string */

extern _connection connections[MAX_CONNECTION_TYPES];

extern void c_reset(OBJECT conn);
extern void c_disconnect(OBJECT conn);

extern int c_getc(OBJECT conn);
extern void c_putc(int ch, OBJECT conn);
extern void c_ungetc(int ch, OBJECT conn);
extern int c_ready(OBJECT conn);
extern int c_eof(OBJECT conn);

extern void c_puts(char *s, OBJECT conn);

extern void c_printf(OBJECT conn, char *fmt, ...);
extern void format(char *fmt, ...);

extern void init_connect(void);
extern void done_connect(void);

#endif
