#include "oom.h"

#include <conio.h>
#include <stdio.h>
#include <signal.h>

PRIVATE char *buf;
PRIVATE int len, buflen;
PRIVATE int pos, eof, ungotten;
PRIVATE int reading;

void console_startup(void) {
    pos = eof = len = buflen = 0;
    buf = NULL;
    reading = 0;
    ungotten = -1;
}

void console_shutdown(void) {
}

void console_open(OBJECT conn) {
}

void console_close(OBJECT conn) {
}

void console_reset(OBJECT conn) {
    pos = eof = len = buflen = 0;
    if (buf != NULL) freemem(buf);
    buf = NULL;
    reading = 0;
    ungotten = '\n';
}

void console_disconnect(OBJECT conn) {
    console_reset(conn);
    eof = 1;
}

void console_dump(OBJECT conn, FILE *f) {
}

void console_load(OBJECT conn, FILE *f) {
}

void console_mark(OBJECT conn) {
}

PRIVATE int cg(void) {
    while (!kbhit() && !shutting_down) swap();
    if (shutting_down) exit_proc();
    return getch();
}

int console_getc(OBJECT conn) {
    int ch;

    if (ungotten != -1) {
        int tmp = ungotten;
        ungotten = -1;
        return tmp;
    }

    while (reading) swap();

    if (len > pos) {
        int tmp = buf[pos];
        pos++;
        if (tmp == 26) {
            eof = 1;
            return ' ';
        }
        return tmp;
    }

    console_reset(conn);
    reading = 1;
    ungotten = -1;
    ch = cg();

    while (ch != '\r' || len == 0) {
        switch (ch) {
            case 0:
                ch = cg();
                break;
            case 3:
                raise(SIGINT);
                break;
            case 8:
                if (len > 0) {
                    len--;

                    switch (buf[len]) {
                        case 9: printf("\b\b\b\b"); break;
                        case 26: printf("\b\b  \b\b"); break;
                        default: printf("\b \b"); break;
                    }
                }
                break;
            case 27:
                printf("\\\n");
                len = 0;
                break;
            case 26:
                printf("^Z");
                /* FALL THROUGH */
            default:
                if (len >= buflen) {
                    buf = growmem(buf, buflen, 256);
                    buflen += 256;
                }
                buf[len++] = ch;
                if (ch == 9)
                    printf("    ");
                else
                    if (ch == 26)
                        ;
                    else
                        fputc(ch, stdout);
        }
        if (ch != '\r') ch = cg();
        if (ch == '\r') {
            fputc('\n', stdout);
            if (len >= buflen) {
                buf = growmem(buf, buflen, 256);
                buflen += 256;
            }
            buf[len++] = '\n';
        }
    }
    reading = 0;
    pos = 1;
    if (buf[0] == 26) {
        eof = 1;
        return ' ';
    }
    return buf[0];
}

void console_putc(int ch, OBJECT conn) {
    fputc(ch, stdout);
    if (ch == '\n') swap();
}

void console_ungetc(int ch, OBJECT conn) {
    ungotten = ch;
}

int console_ready(OBJECT conn) {
    return len > pos || kbhit();
}

int console_eof(OBJECT conn) {
    return eof;
}

