#ifndef __CONSOLE_H
#define __CONSOLE_H

#include <stdio.h>

extern void console_startup(void);
extern void console_shutdown(void);

extern void console_open(OBJECT conn);
extern void console_close(OBJECT conn);
extern void console_reset(OBJECT conn);
extern void console_disconnect(OBJECT conn);

extern void console_dump(OBJECT conn, FILE *f);
extern void console_load(OBJECT conn, FILE *f);

extern void console_mark(OBJECT conn);

extern int console_getc(OBJECT conn);
extern void console_putc(int ch, OBJECT conn);
extern void console_ungetc(int ch, OBJECT conn);

extern int console_ready(OBJECT conn);
extern int console_eof(OBJECT conn);

#endif
