#include "oom.h"

#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <stdio.h>

void fatal(char *form, ...) {
    char s[256];
    va_list vl;

    va_start(vl,form);
    vsprintf(s, form, vl);
    va_end(vl);

    log("---- FATAL ERROR: ~S",s);

    exit(1);
}

void error(char *errname, OBJECT errobj) {
    OBJECT h = curinfo->errstk;
    OBJECT errsym = newsym(errname);
    while (h != NULL) {
        callfunction(CAR(h), 2, errsym, errobj);
        h = CDR(h);
    }
    format("ERROR: %s ", errname);
    print(errobj);
    format("\n");
    resetjmp();
}

void resetjmp(void) {
    curinfo->errstk = NULL;
    if (curinfo->errjmp_ok) longjmp(curinfo->errjmp, 1);
    exit(1);
}

void init_error(void) {
}

