#ifndef __FILE_H
#define __FILE_H

#include <stdio.h>

extern void file_startup(void);
extern void file_shutdown(void);

extern void file_open(OBJECT conn);
extern void file_close(OBJECT conn);
extern void file_reset(OBJECT conn);
extern void file_disconnect(OBJECT conn);

extern void file_dump(OBJECT conn, FILE *f);
extern void file_load(OBJECT conn, FILE *f);

extern void file_mark(OBJECT conn);

extern int file_getc(OBJECT conn);
extern void file_putc(int ch, OBJECT conn);
extern void file_ungetc(int ch, OBJECT conn);

extern int file_ready(OBJECT conn);
extern int file_eof(OBJECT conn);

#endif
