#include "oom.h"

#include <stdlib.h>
#include <ctype.h>

/* An implementation of hashpjw, originally written by P.J. Weinberger
   in a C compiler. Taken from "Compilers: Principles, Techniques and
   Tools" by Aho, Sethi and Ullman
                (Addison-Wesley 1986, ISBN 0-201-10194-7) */

ulong hash_str(char *string) {
    ulong hash = 0, g;

    if (string == NULL) return 0;

    while (*string) {
        hash = (hash << 4) + tolower(*string++);
        g = hash & 0xf0000000L;
        if (g) {
            hash = hash ^ (g >> 24);
            hash = hash ^ g;
        }
    }
    return hash;
}

