#include "oom.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdarg.h>

OBJECT newstack(long maxsize) {
    return cons(newint(0),newvector(maxsize));
}

int stack_size(OBJECT stack) {
    return (int) GETINT(CAR(stack));
}

void push(OBJECT stack, OBJECT obj) {
    int idx = (int) GETINT(CAR(stack));
    OBJECT vec = CDR(stack);

    if (idx == GETLEN(vec)) return;

    SETELEM(vec, idx, obj);
    SETCAR(stack, newint(idx + 1));
}

OBJECT pop(OBJECT stack) {
    int idx = (int) GETINT(CAR(stack));
    OBJECT val;

    if (idx == 0) return NULL;

    idx--;
    SETCAR(stack,newint(idx));

    val = GETELEM(CDR(stack),idx);
    SETELEM(CDR(stack), idx, NULL);
    return val;
}

OBJECT peek(OBJECT stack) {
    return GETELEM(CDR(stack), (word) GETINT(CAR(stack)) - 1);
}

OBJECT enter_scope(OBJECT prev, word size) {
    OBJECT o = newvector(size+1);

    SETELEM(o, size, prev);
    return o;
}

OBJECT leave_scope(OBJECT scope) {
    return GETELEM(scope, GETLEN(scope) - 1);
}

OBJECT s_lookup(OBJECT scope, word snum, word ofs) {
    while (snum) {
        scope = GETELEM(scope, GETLEN(scope) - 1);
        snum--;
    }

    return GETELEM(scope, ofs);
}

OBJECT s_set(OBJECT scope, word snum, word ofs, OBJECT val) {
    while (snum) {
        scope = GETELEM(scope, GETLEN(scope) - 1);
        snum--;
    }

    SETELEM(scope, ofs, val);
    return val;
}

void s_setprev(OBJECT scope, OBJECT prev) {
    SETELEM(scope, GETLEN(scope) - 1, prev);
}

#define WIZARD(obj)     ((findobj(GETONUM(obj))->flags & FO_WIZARD) != 0)

OBJECT callfunction(OBJECT fn, int argc, ...) {
    va_list vl;
    OBJECT scope = enter_scope(NULL, argc);
    int i;

    va_start(vl, argc);
    for (i=0; i<argc; i++)
        s_set(scope, 0, i, va_arg(vl, OBJECT));
    va_end(vl);

    switch (get_type(fn)) {
        case T_PRIM:
            if (argc != primtab[GETPNUM(fn)].argc)
                error("wrong-args",fn);
            switch (argc) {
                case 0: return primtab[GETPNUM(fn)].proc();
                case 1: return primtab[GETPNUM(fn)].proc(GETELEM(scope,0));
                case 2: return primtab[GETPNUM(fn)].proc(GETELEM(scope,0),
                                                         GETELEM(scope,1));
                case 3: return primtab[GETPNUM(fn)].proc(GETELEM(scope,0),
                                                         GETELEM(scope,1),
                                                         GETELEM(scope,2));
                case 4: return primtab[GETPNUM(fn)].proc(GETELEM(scope,0),
                                                         GETELEM(scope,1),
                                                         GETELEM(scope,2),
                                                         GETELEM(scope,3));
                case 5: return primtab[GETPNUM(fn)].proc(GETELEM(scope,0),
                                                         GETELEM(scope,1),
                                                         GETELEM(scope,2),
                                                         GETELEM(scope,3),
                                                         GETELEM(scope,4));
                default:
                    fatal("Unhandled primitive argc, %d", argc);
            }
            break;
        case T_FUNC: {
            OBJECT s = NULL;
            OBJECT p = NULL;
            OBJECT ca;

            s_setprev(scope, GETENV(fn));

            if (argc != GETBODY(fn)[0]) error("wrong-args",fn);
            if (argc > 0)
                if (get_type(s_lookup(scope, 0, 0)) == T_OBJECT) {
                    s = s_lookup(scope, 0, 0);
                    if (validobjnum(GETONUM(s)))
                        p = findobj(GETONUM(s))->parent;
                }

            ca = curinfo->caller;
            curinfo->caller = curinfo->code_owner;
            interp(fn, GETBODY(fn)+3, s, p, scope);
            curinfo->caller = ca;
            return pop(curinfo->stack);
        }
    }
    return NULL;
}

OBJECT callmethod(OBJECT obj, char *name, int argc, ...) {
    va_list vl;
    OBJECT meth, info, class;
    OBJECT scope = enter_scope(NULL, argc+1);
    OBJECT co, ca;
    int i;

    va_start(vl, argc);
    for (i = 1 ; i <= argc ; i++ )
        s_set(scope, 0, i, va_arg(vl, OBJECT));
    s_set(scope, 0, 0, obj);

    va_end(vl);

    meth = findmeth(findobj(GETONUM(obj)), name, &info, &class);
    if (meth == NULL) return NULL;

    if (get_type(meth) != T_FUNC) error("type-error",meth);

    class = findobj(GETONUM(class))->parent;
    s_setprev(scope, GETENV(meth));

    if (argc+1 != GETBODY(meth)[0]) error("wrong-args",meth);

    co = curinfo->code_owner;
    ca = curinfo->caller;
    curinfo->code_owner = CAR(CDR(info));
    curinfo->caller = co;
    interp(meth, GETBODY(meth)+3, obj, class, scope);
    curinfo->caller = ca;
    curinfo->code_owner = co;

    return pop(curinfo->stack);
}

void fork_after(OBJECT args) {
    long time_to_wait;
    OBJECT thunk, scope, self, parent;
    long start_time = clock();

    if (shutting_down) {
    }

    time_to_wait = GETINT(CAR(args));
    thunk = CAR(CDR(args));
    scope = CAR(CDR(CDR(args)));
    self = CAR(CDR(CDR(CDR(args))));
    parent = CDR(CDR(CDR(CDR(args))));

    do {
        swap();
        if (shutting_down) {
            time_to_wait -= (clock() - start_time) * 10 / 182;
            SETCAR(args, newint(time_to_wait));
            args = cons(curinfo->player,
                    cons(curinfo->code_owner,
                        cons(curinfo->conn,
                            cons(newint(curinfo->task_id), args))));
            shutdown_tasks = cons(args, shutdown_tasks);
            exit_proc();
        }
    } while ((clock() - start_time) * 10 < time_to_wait * 182);

    curinfo->stack = newstack(INTERP_OBJSTACKSIZE);
    interp(thunk, GETBODY(thunk) + 3, self, parent, scope);
    curinfo->stack = NULL;
}

#define advance_str(ip)   { while (*ip != '\0') ip++; ip++; }

void interp(OBJECT func, char *ip, OBJECT self, OBJECT parent, OBJECT scope) {
    unsigned char bytecode;
    OBJECT newself = NULL;
    OBJECT stack = curinfo->stack;

    while (1) {
        bytecode = *ip++;

        if (bytecode == OP_RET) break;

        switch (bytecode) {
            case OP_CONST_NUM:
                push(stack, newint(* (long *) ip));
                ip += 4;
                break;
            case OP_CONST_STR:
                push(stack, newstring(ip));
                advance_str(ip);
                break;
            case OP_CONST_SYM:
                push(stack, newsym(ip));
                advance_str(ip);
                break;
            case OP_CONST_FUNCTION: {
                char argc = *ip++;
                word len = * (word *) ip;

                ip += 2;
                push(stack, newfunc(scope, argc, len, ip));
                ip += len;
                break;
            }
            case OP_CONST_OBJECT:
                push(stack, newself = MKONUM(* (long *) ip));
                ip += 4;
                break;
            case OP_CONST_NULL:
                push(stack, NULL);
                break;
            case OP_CONST_TRUE:
                push(stack, true);
                break;
            case OP_CONST_FALSE:
                push(stack, false);
                break;
            case OP_REF_LOCAL: {
                word snum, ofs;

                snum = ((word *)ip)[0];
                ofs  = ((word *)ip)[1];
                ip += 4;

                push(stack, newself = s_lookup(scope, snum, ofs));
                break;
            }
            case OP_REF_PRIM:
                push(stack, newself = newprim(*(word *)ip));
                ip += 2;
                break;
            case OP_REF_SLOT: {
                OBJECT obj = pop(stack);
                OBJECT val;

                if (get_type(obj) != T_OBJECT) error("invalid-object",obj);

                val = findslot(findobj(GETONUM(obj)), ip);
                if (val == NULL) error("slot-not-found",newsym(ip));

                if (CAR(CDR(val)) != curinfo->code_owner &&
                    !WIZARD(curinfo->code_owner))
                    if ((GETINT(CDR(CDR(val))) & F_READ) == 0)
                        error("no-permission",newsym(ip));

                advance_str(ip);
                push(stack, newself = CAR(val));
                break;
            }
            case OP_REF_PARENT: {
                OBJECT obj = pop(stack);

                if (get_type(obj) != T_OBJECT) error("invalid-object",obj);

                if (obj == self)
                    push(stack, parent);
                else
                    push(stack, newself = findobj(GETONUM(obj))->parent);
                break;
            }
            case OP_REF_METHOD: {
                OBJECT obj = pop(stack);
                OBJECT meth, info, class;

                if (get_type(obj) != T_OBJECT) error("invalid-object",obj);

                meth = findmeth(findobj(GETONUM(obj)), ip, &info, &class);
                if (meth == NULL) error("method-not-found",newsym(ip));

                if (CAR(CDR(info)) != curinfo->code_owner &&
                    !WIZARD(curinfo->code_owner))
                    if ((GETINT(CDR(CDR(info))) & F_READ) == 0)
                        error("no-permission",newsym(ip));

                advance_str(ip);
                push(stack, meth);
                break;
            }
            case OP_SET_LOCAL: {
                OBJECT obj = peek(stack);
                word snum, ofs;

                snum = ((word *)ip)[0];
                ofs  = ((word *)ip)[1];
                ip += 4;

                s_set(scope, snum, ofs, newself = obj);
                break;
            }
            case OP_SET_SLOT: {
                OBJECT val = pop(stack);
                OBJECT obj = pop(stack);
                OBJECT cell;

                if (get_type(obj) != T_OBJECT) error("invalid-object",obj);

                cell = findslot(findobj(GETONUM(obj)), ip);
                if (cell == NULL) error("slot-not-found",newsym(ip));

                if (CAR(CDR(cell)) != curinfo->code_owner &&
                    !WIZARD(curinfo->code_owner))
                        if ((GETINT(CDR(CDR(cell))) & F_WRITE) == 0)
                            error("no-permission",newsym(ip));

                advance_str(ip);
                SETCAR(cell, val);
                push(stack, newself = val);
                break;
            }
            case OP_DEF_SLOT: {
                OBJECT val = pop(stack);
                OBJECT obj = pop(stack);
                OBJECT cell;
                OBJINFO o;

                if (get_type(obj) != T_OBJECT) error("invalid-object",obj);
                o = findobj(GETONUM(obj));

                if (o->owner != curinfo->code_owner &&
                    !WIZARD(curinfo->code_owner))
                    if ((o->flags & FO_WRITE) == 0)
                        error("no-permission",obj);

                cell = findslot(o, ip);
                if (cell == NULL)
                    addslot(o, newsym(ip), val, curinfo->code_owner,
                            newint(0));
                else
                    SETCAR(cell, val);
                advance_str(ip);
                push(stack, newself = val);
                break;
            }
            case OP_DEF_METHOD: {
                OBJECT val = pop(stack);
                OBJECT obj = pop(stack);
                OBJECT cell, info, class;

                if (get_type(obj) != T_OBJECT) error("invalid-object",obj);
                if (get_type(val) != T_FUNC) error("type-error",val);

                cell = findmeth(findobj(GETONUM(obj)), ip, &info, &class);

                if (cell == NULL || class != obj) {
                    if (findobj(GETONUM(obj))->owner != curinfo->code_owner &&
                        !WIZARD(curinfo->code_owner))
                        if ((findobj(GETONUM(obj))->flags & FO_WRITE) == 0)
                            error("no-permission",newsym(ip));
                    addmeth(findobj(GETONUM(obj)), newsym(ip), val,
                        curinfo->code_owner,
                            (cell == NULL) ? newint(0) : CDR(CDR(info)));
                } else {
                    if (CAR(CDR(info)) != curinfo->code_owner &&
                        !WIZARD(curinfo->code_owner))
                            if ((GETINT(CDR(CDR(info))) & F_WRITE) == 0)
                                error("no-permission",newsym(ip));
                    SETCAR(info, val);
                }

                advance_str(ip);
                push(stack, newself = val);
                break;
            }
            case OP_CALL: {
                char argc = *ip;
                char fntype;
                OBJECT func;
                OBJECT newscope;
                int i;

                ip++;
                newscope = enter_scope(NULL, argc);
                for (i = argc - 1; i >= 0; i--)
                    s_set(newscope, 0, i, pop(stack));

                func = pop(stack);
                fntype = get_type(func);

                if (fntype != T_FUNC &&
                    fntype != T_PRIM)
                        error("type-error",func);

                switch (fntype) {
                    case T_PRIM:
                        if (argc != primtab[GETPNUM(func)].argc)
                            error("wrong-args",func);
                        switch (argc) {
                            case 0: push(stack,
                                        newself = primtab[GETPNUM(func)].proc(
                                            ));
                                    break;
                            case 1: push(stack,
                                        newself = primtab[GETPNUM(func)].proc(
                                            GETELEM(newscope, 0)));
                                    break;
                            case 2: push(stack,
                                        newself = primtab[GETPNUM(func)].proc(
                                            GETELEM(newscope, 0),
                                            GETELEM(newscope, 1)));
                                    break;
                            case 3: push(stack,
                                        newself = primtab[GETPNUM(func)].proc(
                                            GETELEM(newscope, 0),
                                            GETELEM(newscope, 1),
                                            GETELEM(newscope, 2)));
                                    break;
                            case 4: push(stack,
                                        newself = primtab[GETPNUM(func)].proc(
                                            GETELEM(newscope, 0),
                                            GETELEM(newscope, 1),
                                            GETELEM(newscope, 2),
                                            GETELEM(newscope, 3)));
                                    break;
                            case 5: push(stack,
                                        newself = primtab[GETPNUM(func)].proc(
                                            GETELEM(newscope, 0),
                                            GETELEM(newscope, 1),
                                            GETELEM(newscope, 2),
                                            GETELEM(newscope, 3),
                                            GETELEM(newscope, 4)));
                                    break;
                            default:
                                fatal("Unhandled primitive argc, %d",argc);
                        }
                        break;
                    case T_FUNC: {
                        OBJECT s = NULL;
                        OBJECT p = NULL;
                        OBJECT ca;

                        s_setprev(newscope, GETENV(func));

                        if (argc != GETBODY(func)[0]) error("wrong-args",func);
                        if (argc > 0)
                            if (get_type(s_lookup(newscope, 0, 0)) == T_OBJECT)
                            {
                                s = s_lookup(newscope, 0, 0);
                                if (validobjnum(GETONUM(s)))
                                    p = findobj(GETONUM(s))->parent;
                            }

                        ca = curinfo->caller;
                        curinfo->caller = curinfo->code_owner;
                        interp(func, GETBODY(func)+3, s, p, newscope);
                        newself = peek(stack);
                        curinfo->caller = ca;

                        break;
                    }
                }
                break;
            }
            case OP_PRE_METHCALL:
                push(stack, newself);
                break;
            case OP_CALL_METHOD: {
                char argc = *ip;
                OBJECT obj;
                OBJECT meth, info, class;
                OBJECT newscope, co, ca;
                int i;

                ip++;
                newscope = enter_scope(NULL, argc + 1);
                for (i = argc; i >= 1; i--)
                    s_set(newscope, 0, i, pop(stack));
                s_set(newscope, 0, 0, newself = pop(stack));
                obj = pop(stack);

                if (get_type(obj) != T_OBJECT)
                    error("invalid-object",obj);

                meth = findmeth(findobj(GETONUM(obj)), ip, &info, &class);
                if (meth == NULL) error("method-not-found",newsym(ip));

                advance_str(ip);

                class = findobj(GETONUM(class))->parent;
                s_setprev(newscope, GETENV(meth));

                if (get_type(meth) != T_FUNC) error("type-error",meth);

                if (argc+1 != GETBODY(meth)[0]) error("wrong-args",meth);

                co = curinfo->code_owner;
                ca = curinfo->caller;
                curinfo->code_owner = CAR(CDR(info));
                curinfo->caller = co;
                interp(meth, GETBODY(meth)+3, newself, class, newscope);
                newself = peek(stack);
                curinfo->code_owner = co;
                curinfo->caller = ca;
                break;
            }
            case OP_FORK_AFTER: {
                long num_seconds = *(long *)ip;
                OBJECT thunk = pop(stack);  /* Guaranteed to be a thunk */
                OBJECT info;
                PROCINFO pi;

                ip += 4;

                info = cons(newint(num_seconds),
                        cons(thunk,
                            cons(GETENV(thunk),
                                cons(self, parent))));

                pi = fork(fork_after, info, INTERP_STACKSIZE);
                pi->task_id = next_task_id++;
                pi->ticks_left = TICK_QUOTA;
                push(stack, newint(pi->task_id));
                break;
            }
            case OP_POP:
                pop(stack);
                newself = peek(stack);
                break;
            case OP_DUP:
                push(stack, peek(stack));
                break;
            case OP_ENTER_SCOPE:
                scope = enter_scope(scope, *(word *)ip);
                ip += 2;
                break;
            case OP_LEAVE_SCOPE:
                scope = leave_scope(scope);
                break;
            case OP_CONS: {
                OBJECT car, cdr;
                cdr = pop(stack);
                car = pop(stack);
                push(stack, cons(car, cdr));
                break;
            }
            case OP_NCONS: {
                OBJECT cdr;
                word n = *(word *)ip;

                ip += 2;
                cdr = pop(stack);
                while (n > 0) {
                    cdr = cons(pop(stack), cdr);
                    n--;
                }
                push(stack, cdr);
                break;
            }
            case OP_JUMP:
                ip += *(int *)ip;
                break;
            case OP_JUMP_TRUE:
                if (pop(stack) == false) ip += 2; else ip += *(int *)ip;
                break;
            case OP_JUMP_FALSE:
                if (pop(stack) != false) ip += 2; else ip += *(int *)ip;
                break;
            case OP_JUMP_NULL:
                if (pop(stack) == NULL) ip += *(int *)ip; else ip += 2;
                break;
            case OP_NOT:
                push(stack, pop(stack) == false ? true : false);
                break;
            case OP_OR: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, (a != false || b != false) ? true : false);
                break;
            }
            case OP_AND: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, (a != false && b != false) ? true : false);
                break;
            }
            case OP_EQ: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, equalfun(a, b));
                break;
            }
            case OP_NE: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, equalfun(a, b) == false ? true : false);
                break;
            }
            case OP_GT: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, gtfun(a, b));
                break;
            }
            case OP_LT: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, ltfun(a, b));
                break;
            }
            case OP_GE: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, ltfun(a, b) == false ? true : false);
                break;
            }
            case OP_LE: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, gtfun(a, b) == false ? true : false);
                break;
            }
            case OP_PLUS: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, addfun(a, b));
                break;
            }
            case OP_MINUS: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, subfun(a, b));
                break;
            }
            case OP_STAR: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, mulfun(a, b));
                break;
            }
            case OP_SLASH: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, divfun(a, b));
                break;
            }
            case OP_PERCENT: {
                OBJECT b = pop(stack);
                OBJECT a = pop(stack);
                push(stack, modfun(a, b));
                break;
            }
            default:
                fatal("Unknown bytecode 0x%x\n", bytecode);
        }
        if (curinfo->ticks_left != -1)
            if (--curinfo->ticks_left <= 0) exit_proc();
        swap();
    }
    swap();
}

OBJECT true, false;
long next_task_id;

void init_interp(void) {
    true = newsym("true");
    false = newsym("false");
    next_task_id = 1;   /* 0 is for tasks without task-ids */
}

