#ifndef __INTERP_H
#define __INTERP_H

#define INTERP_STACKSIZE 32768L     /* bytes per interp _process_ stack */
#define INTERP_OBJSTACKSIZE 1024L   /* objects per interp _object_ stack */

#define TICK_QUOTA  15000

extern OBJECT newstack(long maxsize);
extern int stack_size(OBJECT stack);
extern void push(OBJECT stack, OBJECT obj);
extern OBJECT pop(OBJECT stack);
extern OBJECT peek(OBJECT stack);

extern OBJECT callfunction(OBJECT fn, int argc, ...);
extern OBJECT callmethod(OBJECT obj, char *name, int argc, ...);
extern void fork_after(OBJECT args);
extern void interp(OBJECT func, char *ip, OBJECT self,
                   OBJECT parent, OBJECT scope);

extern OBJECT true, false;
extern long next_task_id;

extern void init_interp(void);

#endif
