#include "oom.h"

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <time.h>

FILE *log_file;

PRIVATE void log_date(void) {
    time_t t;
    char *s;

    time(&t);
    s = ctime(&t);
    s[strlen(s)-1] = '\0';    /* Chop off newline */
    fprintf(log_file, "%s", s);
}

void log(char *fmt, ...) {
    va_list vl;

    log_date();
    fprintf(log_file, ": ");
    va_start(vl, fmt);

    while (*fmt != '\0') {
        if (*fmt == '~') {
            fmt++;
            switch (*fmt) {
                case 'S':
                    fprintf(log_file, "%s", va_arg(vl, char *));
                    break;
                case 'N':
                    fprintf(log_file, "%ld", va_arg(vl, long));
                    break;
                case 'C':
                    fprintf(log_file, "%c", (char) va_arg(vl, word));
                    break;
                case 'P':
                    fprintf(log_file, "%p", va_arg(vl, void *));
                    break;
                case 'O':
                    fprintf(log_file, "#%ld", GETONUM(va_arg(vl, void *)));
                    break;
            }
        } else fputc(*fmt, log_file);
        fmt++;
    }

    va_end(vl);
    fprintf(log_file, "\n");
}

void init_log(char *logname) {
    log_file = fopen(logname, "at");

    fprintf(log_file, "\n");
/*    fprintf(log_file, "\nSystem up at ");
    log_date();
    fprintf(log_file, ".\n\n"); */
}

