#ifndef __MEMORY_H
#define __MEMORY_H

#include <stdio.h>

/*  *   *   *   *   *   *   *   IMPORTANT   *   *   *   *   *   *   *
 *
 *  Make sure your malloc() returns pointers which are even-byte aligned!
 *  Not doing so will kill the way the system encodes ints & objects as
 *  having the low bit of the pointer set! THIS WILL CAUSE SYSTEM CRASHES!
 *  Note: the only place malloc() is used is in .memory.getmem(), you can
 *  replace it there if required. (free() is only used in .memory.freemem())
 *
 *                      You Have Been Warned ... ( :-) )
 *
 *  eg.: Valid object ptrs: 0000:0000, 0135:7796
 *     Invalid object ptrs: 0000:0001, 0135:7799
 */

typedef struct __objinfo *OBJINFO;
typedef struct __object *OBJECT;

typedef struct __objinfo {
    long number;
    OBJINFO next;
    long flags;
    OBJECT parent, children;
    OBJECT slotnames, slotvals;
    OBJECT methnames, methvals;
    OBJECT name, owner, location, contents;
} _objinfo;

#define FO_PLAYER        0x00000001     /* Flags in objinfo.flags */
#define FO_PROGRAMMER    0x00000002
#define FO_WIZARD        0x00000004
#define FO_READ          0x00000008
#define FO_WRITE         0x00000010
#define FO_COPY          0x00000020


#define F_READ          0x00000001      /* Flags per slot / method */
#define F_WRITE         0x00000002
#define F_CHANGEOWN     0x00000004


/* Structure of method/slot lists:
 *
 *      /\                    /\            On NEW: 
 *  name /\  value,owner,flags /\            * reference name-list
 *   name /\  value,owner,flags /\           * cons(cons(val,owner-flags),rest)
 *    name /\  value,owner,flags /\          
 *     name /\  value,owner,flags /\                            
 *            .                     .
 *             .                     .
 *
 */

typedef struct __object {
    int type;
    union {
        struct {
            char *data;
            ulong hash;
        } strsym;
        struct { OBJECT car, cdr; } cons;
        struct {
            OBJECT env;
            char *body;     /* First byte is no. of args , 2nd:3rd = bodylen */
        } function;
        struct {
            long length;
            OBJECT *vec;
        } vector;
        struct {
            int type;
            int info;
            union {
                FILE *f;
                OBJECT o;
                char *s;
                long l;
            } d;
        } connection;
    } d;
} _object;

#define T_NULL      0
#define T_INT       1
#define T_STRING    2
#define T_SYM       3
#define T_CONS      4
#define T_FUNC      5
#define T_PRIM      6
#define T_VECTOR    7
#define T_CONN      8
#define T_OBJECT    9

#define T_FREELIST  0x7F

#define T_MARK      0x80

extern void *getmem(word size);
extern void *growmem(void *oldblk, word oldsize, int incr);
extern void freemem(void *mem);
extern void gc(void);
extern void dump_on(FILE *f);       /* Dumps system state */
extern void load_from(FILE *f);     /* Loads system state */

#define streq_ss(a,b)   (!stricmp(a,b))
#define streq_os(a,b)   (!stricmp(GETSTR(a),b))
extern int streq_oo(OBJECT a, OBJECT b);

extern OBJECT shallow_copy(OBJECT list);

extern int get_type(OBJECT o);

#define newint(v)   ((OBJECT)(((v)<<2)|1))
#define GETINT(o)   (((long)(o))>>2)

extern OBJECT newstring(char *val);
extern OBJECT newsym(char *val);
#define GETSTR(o)   ((o)->d.strsym.data)
#define GETHASH(o)  ((o)->d.strsym.hash)

extern OBJECT cons(OBJECT car, OBJECT cdr);
#define CAR(o)      ((o)->d.cons.car)
#define CDR(o)      ((o)->d.cons.cdr)
#define SETCAR(o,c) ((o)->d.cons.car = (c))
#define SETCDR(o,c) ((o)->d.cons.cdr = (c))

extern OBJECT newfunc(OBJECT env, char argc, word codelen, char *codebuf);
#define GETENV(o)   ((o)->d.function.env)
#define GETBODY(o)  ((o)->d.function.body)

#define newprim(pn) ((OBJECT)((pn<<3)|7))
#define GETPNUM(o)  (((word)o)>>3)

extern OBJECT newvector(long length);
#define GETLEN(o)       ((word) (o)->d.vector.length)
#define GETELEM(o,i)    ((o)->d.vector.vec[i])
#define SETELEM(o,i,v)  ((o)->d.vector.vec[i] = (v))

extern OBJECT newconn(int type, int info, void *data);
#define GETCTYPE(o)     ((o)->d.connection.type)
#define GETCINFO(o)     ((o)->d.connection.info)
#define GETCONNF(o)     ((o)->d.connection.d.f)
#define GETCONNO(o)     ((o)->d.connection.d.o)
#define GETCONNS(o)     ((o)->d.connection.d.s)
#define GETCONNL(o)     ((o)->d.connection.d.l)

extern OBJECT maxobj(void);                    /* Returns highest yet objnum */
extern OBJECT values_copy(OBJECT list, OBJECT newown);     /* Copies vallist */
extern OBJECT newobj(OBJECT parent, OBJECT player);  /* Creates some OBJINFO */
extern void freeobj(OBJECT o);                         /* Kills some OBJINFO */
extern OBJINFO findobj(long onum);                     /* Finds some OBJINFO */
extern int validobjnum(long onum);               /* Checks onum for validity */
#define GETONUM(o)  (((long)o)>>3)
#define MKONUM(n)   ((OBJECT)(((n)<<3)|3))

extern OBJECT findslot(OBJINFO o, char *name);
            /* Extract car to get value */
            /* Set car to set value */
            /* Extract cdr to get info */
            /* Set cdr to set info */
            /* CAR(info) = owner, CDR(info) = flags */
extern OBJECT findmeth(OBJINFO o, char *name, OBJECT *info, OBJECT *found_in);
            /* Extract cdr of *info to get info */
            /* Set cdr of *info to set info */
            /* info-struct is same as findslot */

extern void addslot(OBJINFO o, OBJECT name, OBJECT val,
                               OBJECT owner, OBJECT flags);
extern void addmeth(OBJINFO o, OBJECT name, OBJECT val,
                               OBJECT owner, OBJECT flags);

extern void init_memory(void);

#endif
