#include "oom.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

PRIVATE char *prepositions[] = {
    "with",
    "using",
    "at",
    "to",
    "in",
    "on",
    "onto",
    "from",
    "over",
    "through",
    "under",
    "beside",
    "for",
    "about",
    "is",
    "as",
    "off",
    "of",
    NULL
};

PRIVATE int preposition(char *s) {
    int i = 0;

    while (prepositions[i] != NULL) {
        if (streq_ss(s,prepositions[i])) return 1;
        i++;
    }
    return 0;
}

#define START           0
#define WORD            1
#define SAY             2
#define EMOTE           3

#define GO(st)  { state = st; continue; }

#define NON_WORD_STR    "\":;"

void mud_scanner(SCANSTATE s) {
    int state = START;
    char c;
    char *str;

    while (1) {
        switch (state) {
            case START:
                c = scan_peek(s);

                if (c_eof(s->conn)) EMIT_S(s,"end-of-file",NULL)

                if (c == '\n') {
                    scan_drop(s);
                    EMIT_S(s,"end-of-line",NULL)
                }

                if (isspace(c)) {
                    scan_drop(s);
                    GO(START);
                }

                if (strchr(NON_WORD_STR, c) == NULL) GO(WORD);

                scan_drop(s);

                switch (c) {
                    case '"': GO(SAY);
                    case ':': GO(EMOTE);
                    case ';': EMIT_S(s, "eval", NULL)
                }
                break;
            case WORD:
                c = scan_peek(s);
                if (!isspace(c)) {
                    scan_shift(s);
                    GO(WORD);
                }
                str = scan_buf(s);
                if (preposition(str)) EMIT_S(s, "preposition", str) else
                                      EMIT_S(s, "word", str)
            case SAY:
                c = scan_peek(s);
                if (c != '\n') {
                    scan_shift(s);
                    GO(SAY);
                }
                scan_drop(s);
                EMIT_S(s, "say", scan_buf(s))
            case EMOTE:
                c = scan_peek(s);
                if (c != '\n') {
                    scan_shift(s);
                    GO(EMOTE);
                }
                scan_drop(s);
                EMIT_S(s, "emote", scan_buf(s))
        }
    }
}

