#include "oom.h"

#include <string.h>

int check(PARSER p, char *class) {
    if (p->need_scan) {
        p->scan_proc(p->scanner);
        p->need_scan = 0;
    }
    return streq_ss(p->scanner->class, class);
}

int check_drop(PARSER p, char *class, char *errmsg) {
    int result = check(p, class);

    parse_drop(p);
    if (!result) error(errmsg ? errmsg : "Parser error", NULL);
    return result;
}

void parse_drop(PARSER p) {
    if (p->need_scan) p->scan_proc(p->scanner);
    p->need_scan = 1;
}

PARSER newparser(void (*scan_proc)(SCANSTATE scanner),
                 SCANSTATE scanner) {
    PARSER p = getmem(sizeof(_parser));

    p->scan_proc = scan_proc;
    p->scanner = scanner;
    p->need_scan = 1;

    return p;
}

void killparser(PARSER p) {
    freemem(p);
}

