#include "oom.h"

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

SCANSTATE newscanner(char *fn, OBJECT conn) {
    SCANSTATE s = getmem(sizeof(_scanstate));

    s->class = "";
    s->d.s = NULL;
    s->d.l = 0;
    s->filename = fn;
    s->conn = conn;
    s->linenum = 1;
    s->bufsize = 256;
    s->buf = getmem(256);
    resetscanner(s);

    return s;
}

void killscanner(SCANSTATE state) {
    freemem(state->buf);
    freemem(state);
}

void resetscanner(SCANSTATE state) {
    state->pos = 0;
}

char *scan_buf(SCANSTATE state) {
    state->buf[state->pos] = '\0';
    return state->buf;
}

char scan_peek(SCANSTATE state) {
    char ch = c_getc(state->conn);
    c_ungetc(ch, state->conn);
    return ch;
}

void scan_shift(SCANSTATE state) {
    scan_insert(state, c_getc(state->conn));
}

void scan_insert(SCANSTATE state, char c) {
    if (state->pos >= state->bufsize) {
        state->buf = growmem(state->buf, state->bufsize, 256);
        state->bufsize += 256;
    }
    state->buf[state->pos++] = c;
}

void scan_drop(SCANSTATE state) {
    c_getc(state->conn);
}

