#ifndef __SCAN_H
#define __SCAN_H

#include <stdio.h>

typedef struct __scanstate {
    char *class;
    union {
        char *s;
        long l;
    } d;
    char *filename;
    OBJECT conn;
    int linenum;
    int bufsize;
    char *buf;
    int pos;
} _scanstate, *SCANSTATE;

extern SCANSTATE newscanner(char *fn, OBJECT conn);
extern void killscanner(SCANSTATE state);
extern void resetscanner(SCANSTATE state);

#define EMIT_S(s, c, v) {   \
    s->class = c;           \
    s->d.s = v;             \
    resetscanner(s);        \
    return;                 \
}

#define EMIT_L(s, c, v) {   \
    s->class = c;           \
    s->d.l = v;             \
    resetscanner(s);        \
    return;                 \
}

extern char *scan_buf(SCANSTATE state);

extern char scan_peek(SCANSTATE state);
extern void scan_shift(SCANSTATE state);
extern void scan_insert(SCANSTATE state, char c);
extern void scan_drop(SCANSTATE state);

#endif
