#ifndef __SERIAL_H
#define __SERIAL_H

#include <stdio.h>

extern void serial_startup(void);
extern void serial_shutdown(void);

extern void serial_open(OBJECT conn);
extern void serial_close(OBJECT conn);
extern void serial_reset(OBJECT conn);
extern void serial_disconnect(OBJECT conn);

extern void serial_dump(OBJECT conn, FILE *f);
extern void serial_load(OBJECT conn, FILE *f);

extern void serial_mark(OBJECT conn);

extern int serial_getc(OBJECT conn);
extern void serial_putc(int ch, OBJECT conn);
extern void serial_ungetc(int ch, OBJECT conn);

extern int serial_ready(OBJECT conn);
extern int serial_carrier(OBJECT conn);
extern int serial_eof(OBJECT conn);

#endif
