#include "oom.h"

#include <stdlib.h>
#include <string.h>

SCOPE newscope(SCOPE parent) {
    SCOPE s = getmem(sizeof(_scope));

    s->head = s->tail = NULL;
    s->parent = parent;
    s->size = 0;
    return s;
}

SCOPE killscope(SCOPE scope) {
    SCOPE parent;
    if (scope == NULL) return NULL;

    parent = scope->parent;
    while (scope->head != NULL) {
        BINDING temp = scope->head;
        scope->head = temp->next;
        freemem(temp->name);
        freemem(temp);
    }
    freemem(scope);
    return parent;
}

int lookup(SCOPE scope, char *name, word *snum, word *ofs) {
    BINDING curr;
    word s,o;

    s = o = 0;
    while (scope != NULL) {
        curr = scope->head;
        while (curr != NULL) {
            if (streq_ss(name, curr->name)) {
                *snum = s;
                *ofs = o;
                return 1;
            }
            o++;
            curr = curr->next;
        }
        s++;
        o = 0;
        scope = scope->parent;
    }
    return 0;
}

void addbinding(SCOPE scope, char *name) {
    BINDING b;

    if (!scope) return;

    b = getmem(sizeof(_binding));
    b->name = getmem(strlen(name)+1);
    strcpy(b->name, name);
    b->next = NULL;

    scope->tail =
        (scope->head == NULL) ?
            (scope->head = b) :
            (scope->tail->next = b);

    scope->size++;
    return;
}

#define TABSIZE 211

typedef struct __glbbind *GLBBIND;
typedef struct __glbbind {
    GLBBIND next;
    char *name;
    OBJECT val;
} _glbbind;

PRIVATE GLBBIND glbtab[TABSIZE];

void sweepglbtab(void) {
    int i;
    GLBBIND temp;

    for (i=0; i<TABSIZE; i++) {
        while (glbtab[i] != NULL) {
            temp = glbtab[i]->next;
            freemem(glbtab[i]->name);
            freemem(glbtab[i]);
            glbtab[i] = temp;
        }
    }
}

int refglobal(char *name, OBJECT *val) {
    GLBBIND curr;
    word hash = (word) hash_str(name);

    curr = glbtab[hash % TABSIZE];

    while (curr != NULL) {
        if (streq_ss(curr->name, name)) {
            *val = curr->val;
            return 1;
        }
        curr = curr->next;
    }

    *val = NULL;
    return 0;
}

void addglobal(char *name, OBJECT val) {
    GLBBIND b;
    word hash;

    if (name == NULL || *name == '\0') return;

    b = getmem(sizeof(_glbbind));

    b->name = getmem(strlen(name) + 1);
    strcpy(b->name, name);
    hash = (word) hash_str(name) % TABSIZE;
    b->val = val;
    b->next = glbtab[hash];
    glbtab[hash] = b;
}

void foreachglb(void (*proc)(OBJECT val)) {
    GLBBIND curr;
    int i;

    for (i=0; i<TABSIZE; i++) {
        curr = glbtab[i];
        while (curr != NULL) {
            proc(curr->val);
            curr = curr->next;
        }
    }
}

void init_symtab(void) {
    int i;

    for (i=0; i<TABSIZE; i++) glbtab[i] = NULL;
}

