#ifndef __SYMTAB_H
#define __SYMTAB_H

typedef struct __binding *BINDING;
typedef struct __binding {
    char *name;
    BINDING next;
} _binding;

typedef struct __scope *SCOPE;
typedef struct __scope {
    BINDING head, tail;
    SCOPE parent;
    int size;
} _scope;

extern SCOPE newscope(SCOPE parent);
extern SCOPE killscope(SCOPE scope);    /* returns scope->parent */

extern int lookup(SCOPE scope, char *name, word *snum, word *ofs);
extern void addbinding(SCOPE scope, char *name);

extern void sweepglbtab(void);
extern int refglobal(char *name, OBJECT *val);
extern void addglobal(char *name, OBJECT val);
extern void foreachglb(void (*proc)(OBJECT val));

extern void init_symtab(void);

#endif
