#include "slang.h"
#include <time.h>

extern unsigned _stklen = 50000;    /* EVAL needs a BIG stack! */

PRIVATE long alarm_delay = 0;
PRIVATE long alarm_started_at = 0;
PRIVATE void (*alarm_handler)(void) = NULL;
PRIVATE bool alarm_set = FALSE;
PRIVATE bool alarm_enabled = TRUE;
PRIVATE long alarm_cache = 0;

void set_alarm(FLOAT seconds, void (*handler)()) {
    if (seconds > 0) {
        alarm_handler = handler;
        alarm_started_at = clock();
        alarm_delay = (long)(seconds * CLK_TCK);
        alarm_set = TRUE;
    } else alarm_set = FALSE;
}

void check_alarm(void) {
    if (alarm_enabled &&
        alarm_set &&
        clock()-alarm_started_at >= alarm_delay) {
        alarm_set = FALSE;
        alarm_handler();
    }
}

void disable_alarm(void) {
    alarm_enabled = FALSE;
    alarm_cache = clock();
}

void enable_alarm(void) {
    alarm_enabled = TRUE;
    alarm_started_at += clock() - alarm_cache;
    alarm_cache = 0;
}

OBJECT m_apply(OBJECT proc, OBJECT *formptr, OBJECT *envptr) {
    switch (TYPE(proc)) {
        case T_CLOSURE:
            if (!EQP(ENV(proc),UNDEFD))
                *envptr = addframe(ENV(proc)); else
                if (!NULLP(CAR(CAR(*envptr)))) *envptr = addframe(*envptr);
            *formptr = BODY(proc);
            if (NULLP(*formptr)) return NULL;
            while (!NULLP(CDR(*formptr))) {
                eval(CAR(*formptr),*envptr);
                *formptr = CDR(*formptr);
            }
            *formptr = CAR(*formptr);
            return UNDEFD;
        case T_PRIM:
            PROC(proc)();
            return NULL;
        case T_FPRIM:
            PROC(proc)(*envptr);
            return NULL;
        case T_MPRIM:
            return PROC(proc)(formptr,envptr);
        default:
            push(proc);
            return NULL;
    }
}

void eval(OBJECT form, OBJECT env) {
    OBJECT r;
    bool found;

    while (TRUE) {
        check_alarm();
        switch (TYPE(form)) {
            case T_SYM:
                if (*SDATA(form) == '\'') {
                    push(newstrobj(T_SYM,SDATA(form)+1));
                    return;
                }
                r = refsym(form,env,&found);
                if (!found) {
                    error("Unbound variable",form);
                    return;
                }
                if (!NULLP(m_apply(r,&form,&env))) continue;
                return;
            default:
                push(form);
        }
        return;
    }
}
