#include "slang.h"

OBJECT l_fopen(char *name, char *mode) {
    OBJECT n = newobj();

    LTYPE(n) = T_FILE;
    FNAME(n) = getmem(strlen(name)+1);
    strcpy(FNAME(n),name);

    FHANDLE(n) = fopen(name,mode);
    if (!FHANDLE(n)) {
        gc();
        FHANDLE(n) = fopen(name,mode);
        if (!FHANDLE(n)) return S_FALSE;/* Could not open, for some reason */
    }
    return n;
}

#include <conio.h>
#include <signal.h>

#define MAX_CON_BUF 256
PRIVATE char con_buf[MAX_CON_BUF];
PRIVATE int con_pos = 0;
PRIVATE int con_len = 0;
PRIVATE bool con_eof = FALSE;

PRIVATE int con_getch(void) {
    do check_alarm(); while (!kbhit());
    return getch();
}

PRIVATE int con_getc(void) {
    int c;
    if (con_len) {
        int tmp = con_buf[con_pos];
        con_pos = (con_pos + 1) % MAX_CON_BUF;
        con_len--;
        if (tmp == 26) {
            con_eof = TRUE;
            return 32;  /* Space */
        }
        return tmp;
    }
    con_pos = 0;
    c = con_getch();
    while (c != '\r' || !con_len) {
        switch (c) {
            case 0:
                c = con_getch();
                break;
            case 3: raise(SIGINT);  /* Ctrl-C */
            case 8: /* Backspace */
                if (con_len) {
                    con_pos--;
                    if (con_pos < 0) con_pos = MAX_CON_BUF - 1;
                    con_len--;
                    switch (con_buf[con_pos]) { /* Erase char onscreen */
                        case 9: printf("%c%c%c%c",8,8,8,8); break;
                        case 26: printf("%c%c  %c%c",8,8,8,8); break;
                        default: printf("%c %c",8,8);
                    }
                }
                break;
            case 27: /* Escape */
                printf("\\\n"); /* Show escape-char */
                con_pos = 0;
                con_len = 0;
                break;
            case 26:
                printf("^Z"); /* Otherwise it doesn't show up */
            default:
                if (con_len >= MAX_CON_BUF) {
                    printf("%c",7); /* Beep! */
                    break;
                }
                con_buf[con_pos] = c;
                con_pos = (con_pos + 1) % MAX_CON_BUF;
                con_len++;
                if (c != 9) printf("%c",c); else
                            printf("    ");
        }
        c = con_getch();
        if (c == '\r') {
            printf("\n");
            con_buf[con_pos] = '\n';
            con_len++;
        }
    }
    con_pos = 1;
    con_len--;
    if (con_buf[0] == 26) {
        con_eof = TRUE;
        return 32; /* Space */
    }
    return con_buf[0];
}

PRIVATE void con_ungetc(int c) {
    if (con_len >= MAX_CON_BUF) error("con_ungetc: buffer is full",NULL);
    con_pos--;
    if (con_pos < 0) con_pos = MAX_CON_BUF - 1;
    con_len++;
    con_buf[con_pos] = c;
}

int l_getc(OBJECT file) {
    if (!FILEP(file)) error("getc: expects file; got",file);
    check_alarm();
    if (FHANDLE(file)->flags & _F_TERM) return con_getc(); else
                                        return getc(FHANDLE(file));
}

void l_ungetc(int c, OBJECT file) {
    if (!FILEP(file)) error("ungetc: expects file; got",file);
    check_alarm();
    if (FHANDLE(file)->flags & _F_TERM) con_ungetc(c); else
                                        ungetc(c,FHANDLE(file));
}

bool l_feof(OBJECT file) {
    if (!FILEP(file)) error("feof: expects file; got",file);
    if (FHANDLE(file)->flags & _F_TERM) return con_eof; else
                                        return feof(FHANDLE(file));
}

