#include "slang.h"

OBJECT cons(OBJECT car, OBJECT cdr) {
    OBJECT n = newobj();
    LTYPE(n) = T_CONS;
    CAR(n) = car;
    CDR(n) = cdr;
    return n;
}

OBJECT newint(long i) {
    OBJECT n = newobj();
    LTYPE(n) = T_INT;
    IDATA(n) = i;
    return n;
}

OBJECT newfloat(FLOAT f) {
    OBJECT n = newobj();
    LTYPE(n) = T_FLOAT;
    FDATA(n) = f;
    return n;
}

OBJECT newstrobj(int type, char *s) {
    OBJECT n = newobj();
    LTYPE(n) = type;
    SDATA(n) = getmem(strlen(s)+1);
    strcpy(SDATA(n),s);
    HASH(n) = hash_str(s);
    return n;
}

OBJECT newclosure(OBJECT body, OBJECT env) {
    OBJECT n = newobj();
    LTYPE(n) = T_CLOSURE;
    BODY(n) = body;
    ENV(n) = env;
    return n;
}

OBJECT newprim(int type, OBJECT (*proc)(), char *name) {
    OBJECT n = newobj();
    LTYPE(n) = type;
    PROC(n) = proc;
    PNAME(n) = name;
    return n;
}

OBJECT newvector(long len) {
    OBJECT n = newobj();
    long i;
    LTYPE(n) = T_VECTOR;
    VLEN(n) = len;
    DATA(n) = getmem(len * sizeof(OBJECT));
    for (i=0; i<len; i++) IDX(n,i) = NULL;
    return n;
}

