#include "slang.h"

OBJECT l_fopen(char *name, char *mode) {
    OBJECT n = newobj();

    LTYPE(n) = T_FILE;
    FNAME(n) = getmem(strlen(name)+1);
    strcpy(FNAME(n),name);

    FHANDLE(n) = fopen(name,mode);
    if (!FHANDLE(n)) {
        gc();
        FHANDLE(n) = fopen(name,mode);
        if (!FHANDLE(n)) return S_FALSE;/* Could not open, for some reason */
    }
    return n;
}

int l_getc(OBJECT file) {
    if (!FILEP(file)) error("getc: expects file; got",file);
    check_alarm();
    return getc(FHANDLE(file));
}

void l_ungetc(int c, OBJECT file) {
    if (!FILEP(file)) error("ungetc: expects file; got",file);
    check_alarm();
    ungetc(c,FHANDLE(file));
}

bool l_feof(OBJECT file) {
    if (!FILEP(file)) error("feof: expects file; got",file);
    return feof(FHANDLE(file));
}
