#include "slang.h"
#include <signal.h>

PRIVATE void (*err_handler)(char *message, OBJECT obj) = NULL;

jmp_buf errjmp;
PRIVATE bool errjmp_ready = FALSE;
OBJECT errobj = NULL;

void error(char *message, OBJECT obj) {
    errobj = obj;
    if (err_handler) err_handler(message,obj); else {
        if (NULLP(errobj)) fprintf(stderr,"ERROR: %s\n",message); else {
            fprintf(stderr,"ERROR: %s ",message);
            push(errobj);
            writefun();
            fprintf(stderr,"\n");
        }
    }
    if (NULLP(errobj)) errobj = UNDEFD;
    if (errjmp_ready) longjmp(errjmp,1);
}

void fatal(char *message) {
    fprintf(stderr,"FATAL ERROR: %s\n",message);
    quit();
}

long list_length(OBJECT lst) {
    OBJECT obj = lst;
    long i = 0;
    while (!NULLP(obj) && CONSP(obj)) {
        i++;
        obj = CDR(obj);
    }
    if (!NULLP(obj)) {
        error("list_length: improper list; ",lst);
        return 0;
    }
    return i;
}

OBJECT copy_list(OBJECT lst) {
    OBJECT org = NULL, pp = NULL;
    while (!NULLP(lst) && CONSP(lst)) {
        if (!NULLP(pp)) {
            CDR(pp) = cons(CAR(lst),EOL);
            pp = CDR(pp);
        } else org = pp = cons(CAR(lst),EOL);
        lst = CDR(lst);
    }
    if (!NULLP(lst)) error("copy_list: improper list!",NULL);
    return org;
}

PRIVATE void done_slang(void);              /* Prototype */

void quit(void) {
    if (errjmp_ready) longjmp(errjmp,2);
    done_slang();
    exit(1);
}

PRIVATE void (*oldinth)() = NULL;

PRIVATE void int_handler(void) {
    signal(SIGINT,int_handler);
    error("CTRL-BREAK: user interrupt",NULL);
}

PRIVATE void done_slang(void) {
    signal(SIGINT, oldinth);
}

void init_slang(void (*repl_fun)(), void (*err_fun)(char *msg, OBJECT obj), bool want_init) {
    OBJECT stk;
    stack_start = &stk;
    init_memman();
    init_symtab();
    init_prim();
    oldinth = signal(SIGINT, int_handler);
    err_handler = err_fun;
    switch (setjmp(errjmp)) {
        case 0: /* First time round ONLY */
            if (want_init) {
                push(newstrobj(T_STRING,"init.sla"));
                loadfun();
                pop();
            }
            break;
        case 2:
            done_slang();
            exit(0);
    }
    errjmp_ready = TRUE;
    while (TRUE) repl_fun();    /* Loop: repl_fun must call quit! */
}

